/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.util.keyword.filter;

import cn.bestwu.framework.util.keyword.CharNode;
import cn.bestwu.framework.util.keyword.MatchType;
import cn.bestwu.framework.util.keyword.filter.SimpleKeywordFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SkipKeywordFilter
extends SimpleKeywordFilter {
    private final Set<Character> skipChars = new HashSet<Character>(0);
    private boolean skip = false;

    @Override
    public String replace(String text) {
        if (this.skip) {
            CharNode last = this.root;
            StringBuilder result = new StringBuilder();
            char[] words = text.toCharArray();
            boolean matchShort = this.matchType.equals((Object)MatchType.SHORT);
            ArrayList<Integer> ignoredWords = new ArrayList<Integer>();
            for (int i = 0; i < words.length; ++i) {
                char word = words[i];
                int length = last.getLength();
                int lastIndex = i - (length += ignoredWords.size());
                boolean skipChar = this.skipChars.contains(Character.valueOf(word));
                boolean end = i == words.length - 1;
                boolean containLast = false;
                if (!skipChar) {
                    CharNode charNode = last.get(word);
                    if (charNode != null) {
                        last = charNode;
                        ++length;
                        containLast = true;
                    }
                } else if (!end) {
                    ignoredWords.add(i);
                    continue;
                }
                boolean lastEnd = last.isEnd();
                if (last == this.root) {
                    for (Integer integer : ignoredWords) {
                        result.append(words[integer]);
                    }
                    result.append(word);
                    ignoredWords.clear();
                    continue;
                }
                if (containLast && matchShort && lastEnd) {
                    result.append(this.strategy.replaceWith(Arrays.copyOfRange(words, lastIndex, lastIndex + length)));
                    ignoredWords.clear();
                    last = this.root;
                    continue;
                }
                if (containLast && !end) continue;
                if (lastEnd) {
                    result.append(this.strategy.replaceWith(Arrays.copyOfRange(words, lastIndex, lastIndex + length)));
                    if (!containLast) {
                        --i;
                    }
                } else if (matchShort) {
                    i = lastIndex;
                    result.append(words[i]);
                } else {
                    CharNode failNode = last.getFailNode();
                    if (failNode == this.root) {
                        i = lastIndex;
                        result.append(words[i]);
                    } else {
                        Integer integer;
                        int failLength = failNode.getLength();
                        i = lastIndex + failLength - 1;
                        int count = 0;
                        Iterator iterator = ignoredWords.iterator();
                        while (iterator.hasNext() && (integer = (Integer)iterator.next()) <= i) {
                            ++count;
                        }
                        result.append(this.strategy.replaceWith(Arrays.copyOfRange(words, lastIndex, lastIndex + (failLength += count))));
                    }
                }
                last = this.root;
                ignoredWords.clear();
            }
            return result.toString();
        }
        return super.replace(text);
    }

    public void addSkipChar(Collection<Character> chars) {
        if (null != chars && !chars.isEmpty()) {
            this.skipChars.addAll(chars);
            this.skip = true;
        }
    }
}

