/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework;

import cn.bestwu.framework.data.query.MongodbSearchRepository;
import cn.bestwu.framework.data.query.SearchRepository;
import cn.bestwu.framework.data.query.jpa.JpaSearchRepository;
import cn.bestwu.framework.event.AnnotatedEventHandlerInvoker;
import cn.bestwu.framework.rest.config.RestMvcConfiguration;
import cn.bestwu.framework.rest.resolver.LucenePageableHandlerMethodArgumentResolver;
import cn.bestwu.framework.rest.resolver.LuceneSortHandlerMethodArgumentResolver;
import cn.bestwu.framework.util.AutowireHelper;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.search.jpa.Search;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.auditing.MappingAuditableBeanWrapperFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@AutoConfigureOrder(value=-2147483639)
@Import(value={RestMvcConfiguration.class})
public class DataRestConfiguration {
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public AutowireHelper autowireHelper() {
        return new AutowireHelper();
    }

    @Bean
    @ConditionalOnMissingBean(value={Repositories.class})
    public Repositories repositories() {
        return new Repositories((ListableBeanFactory)this.applicationContext);
    }

    @Bean
    public PersistentEntities persistentEntities() {
        ArrayList arrayList = new ArrayList();
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MappingContext.class).values().forEach(arrayList::add);
        return new PersistentEntities(arrayList);
    }

    @Bean
    public AuditableBeanWrapperFactory auditableBeanWrapperFactory() {
        return new MappingAuditableBeanWrapperFactory(this.persistentEntities());
    }

    @Bean
    public AnnotatedEventHandlerInvoker annotatedEventHandlerInvoker() {
        return new AnnotatedEventHandlerInvoker();
    }

    @Configuration
    @ConditionalOnMissingBean(value={SearchRepository.class})
    @ConditionalOnClass(value={TextCriteria.class})
    protected static class MongodbSearchRepositoryConfiguration {
        @Autowired
        private Repositories repositories;

        protected MongodbSearchRepositoryConfiguration() {
        }

        @Bean
        public SearchRepository searchRepository() {
            return new MongodbSearchRepository(this.repositories);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={SearchRepository.class})
    @ConditionalOnClass(value={Search.class})
    protected static class JpaSearchRepositoryConfiguration {
        @PersistenceContext
        private EntityManager entityManager;
        @Autowired
        private ApplicationEventPublisher publisher;

        protected JpaSearchRepositoryConfiguration() {
        }

        @Bean
        public SearchRepository searchRepository() {
            return new JpaSearchRepository(this.entityManager, this.publisher);
        }

        @Configuration
        protected static class SpringDataWebConfiguration
        extends WebMvcConfigurerAdapter {
            protected SpringDataWebConfiguration() {
            }

            @Bean
            public PageableHandlerMethodArgumentResolver pageableResolver() {
                return new LucenePageableHandlerMethodArgumentResolver(this.lucenceSortResolver());
            }

            @Bean
            public LuceneSortHandlerMethodArgumentResolver lucenceSortResolver() {
                return new LuceneSortHandlerMethodArgumentResolver();
            }

            @Bean
            public SortHandlerMethodArgumentResolver sortResolver() {
                return new SortHandlerMethodArgumentResolver();
            }

            public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
                argumentResolvers.add((HandlerMethodArgumentResolver)this.sortResolver());
                argumentResolvers.add((HandlerMethodArgumentResolver)this.pageableResolver());
            }
        }
    }
}

