/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.config;

import cn.bestwu.framework.rest.aspect.LogAspect;
import cn.bestwu.framework.rest.config.MessageSourceConfiguration;
import cn.bestwu.framework.rest.controller.BaseController;
import cn.bestwu.framework.rest.converter.DefaultElementMixIn;
import cn.bestwu.framework.rest.converter.PageMixIn;
import cn.bestwu.framework.rest.filter.AbstractAuthenticationFailureListener;
import cn.bestwu.framework.rest.filter.AuthorizationFailureListener;
import cn.bestwu.framework.rest.filter.OrderedHttpPutFormContentFilter;
import cn.bestwu.framework.rest.filter.ThreadLocalCleanFilter;
import cn.bestwu.framework.rest.mapping.RepositoryResourceMappings;
import cn.bestwu.framework.rest.mapping.SerializationViewMappings;
import cn.bestwu.framework.rest.mapping.VersionRepositoryRestRequestMappingHandlerMapping;
import cn.bestwu.framework.rest.resolver.DomainMethodArgumentResolver;
import cn.bestwu.framework.rest.resolver.ETagArgumentResolver;
import cn.bestwu.framework.rest.resolver.QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver;
import cn.bestwu.framework.rest.resolver.QuerydslPredicateArgumentResolver;
import cn.bestwu.framework.rest.resolver.RepositoryResourceMetadataHandlerMethodArgumentResolver;
import cn.bestwu.framework.rest.resolver.ResourceMethodArgumentResolver;
import cn.bestwu.framework.rest.resolver.RootResourceInformationHandlerMethodArgumentResolver;
import cn.bestwu.framework.rest.resolver.StandardServletMultipartResolver;
import cn.bestwu.framework.rest.support.BaseErrorAttributes;
import cn.bestwu.framework.rest.support.MailClient;
import cn.bestwu.framework.rest.support.ProxyPathMapper;
import cn.bestwu.framework.rest.support.RequestJsonViewResponseBodyAdvice;
import cn.bestwu.framework.rest.support.UnwrappingRepositoryInvokerFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.HibernateValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.SpringProxy;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.WebMvcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.filter.OrderedRequestContextFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Page;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.querydsl.binding.FixQuerydslPredicateBuilder;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.repository.support.DefaultRepositoryInvokerFactory;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.DateFormatter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.MessageCodeFormatter;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.filter.HttpPutFormContentFilter;
import org.springframework.web.filter.RequestContextFilter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.DelegatingWebMvcConfiguration;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.i18n.FixedLocaleResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import org.springframework.web.servlet.view.ContentNegotiatingViewResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

@Configuration
@ConditionalOnWebApplication
@Import(value={MessageSourceConfiguration.class})
public class RestMvcConfiguration {
    @Bean
    public Module defaultModule() {
        SimpleModule module = new SimpleModule();
        module.setMixInAnnotation(Page.class, PageMixIn.class);
        module.setMixInAnnotation(Object.class, DefaultElementMixIn.class);
        return module;
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorAttributes.class}, search=SearchStrategy.CURRENT)
    public BaseErrorAttributes errorAttributes() {
        return new BaseErrorAttributes();
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpPutFormContentFilter.class})
    public OrderedHttpPutFormContentFilter httpFormContentFilterRegistration() {
        return new OrderedHttpPutFormContentFilter();
    }

    @Bean
    public ThreadLocalCleanFilter threadLocalCleanFilter() {
        return new ThreadLocalCleanFilter();
    }

    @Bean
    public MultipartResolver multipartResolver() {
        StandardServletMultipartResolver standardServletMultipartResolver = new StandardServletMultipartResolver();
        standardServletMultipartResolver.setResolveLazily(true);
        return standardServletMultipartResolver;
    }

    @Configuration
    @ConditionalOnWebApplication
    protected static class EnableWebMvcConfiguration
    extends DelegatingWebMvcConfiguration {
        @Autowired(required=false)
        private WebMvcProperties mvcProperties;
        @Autowired
        private MessageSource messageSource;
        @Autowired
        private StringHttpMessageConverter stringHttpMessageConverter;
        @Autowired
        private ApplicationContext applicationContext;
        @Autowired
        protected ApplicationEventPublisher publisher;
        @Autowired
        private MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter;
        @Autowired(required=false)
        private MappingJackson2XmlHttpMessageConverter mappingJackson2XmlHttpMessageConverter;
        @Autowired(required=false)
        private SerializationViewMappings serializationViewMappings;
        @Autowired(required=false)
        private ProxyPathMapper proxyPathMapper;

        protected EnableWebMvcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Repositories.class})
        public Repositories repositories() {
            return new Repositories((ListableBeanFactory)this.applicationContext);
        }

        @Bean
        public RepositoryInvokerFactory repositoryInvokerFactory() {
            return new UnwrappingRepositoryInvokerFactory((RepositoryInvokerFactory)new DefaultRepositoryInvokerFactory(this.repositories(), (ConversionService)this.mvcConversionService()));
        }

        @Lazy
        @Bean
        public QuerydslBindingsFactory querydslBindingsFactory() {
            return new QuerydslBindingsFactory((EntityPathResolver)SimpleEntityPathResolver.INSTANCE);
        }

        @Lazy
        @Bean
        public FixQuerydslPredicateBuilder querydslPredicateBuilder() {
            return new FixQuerydslPredicateBuilder((ConversionService)this.mvcConversionService(), this.querydslBindingsFactory().getEntityPathResolver());
        }

        @Bean
        public RepositoryResourceMetadataHandlerMethodArgumentResolver repositoryResourceMetadataHandlerMethodArgumentResolver() {
            return new RepositoryResourceMetadataHandlerMethodArgumentResolver(this.repositoryResourceMappings());
        }

        @Bean
        public RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver() {
            if (QueryDslUtils.QUERY_DSL_PRESENT) {
                return new QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver(this.repositories(), this.repositoryInvokerFactory(), this.repositoryResourceMetadataHandlerMethodArgumentResolver(), this.querydslPredicateBuilder(), this.querydslBindingsFactory(), this.publisher);
            }
            return new RootResourceInformationHandlerMethodArgumentResolver(this.repositoryInvokerFactory(), this.repositoryResourceMetadataHandlerMethodArgumentResolver());
        }

        private List<AbstractJackson2HttpMessageConverter> messageConverters() {
            ArrayList<AbstractJackson2HttpMessageConverter> messageConverters = new ArrayList<AbstractJackson2HttpMessageConverter>(2);
            messageConverters.add((AbstractJackson2HttpMessageConverter)this.mappingJackson2HttpMessageConverter);
            if (this.mappingJackson2XmlHttpMessageConverter != null) {
                messageConverters.add((AbstractJackson2HttpMessageConverter)this.mappingJackson2XmlHttpMessageConverter);
            }
            return messageConverters;
        }

        protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            super.addArgumentResolvers(argumentResolvers);
            argumentResolvers.add(this.repoRequestArgumentResolver());
            argumentResolvers.add(new DomainMethodArgumentResolver(this.repositoryInvokerFactory(), this.messageConverters()));
            argumentResolvers.add(new ResourceMethodArgumentResolver(this.repositoryResourceMetadataHandlerMethodArgumentResolver(), this.repositoryInvokerFactory(), this.messageConverters()));
            if (QueryDslUtils.QUERY_DSL_PRESENT) {
                argumentResolvers.add(0, new QuerydslPredicateArgumentResolver(this.querydslBindingsFactory(), this.querydslPredicateBuilder()));
            }
            argumentResolvers.add(new ETagArgumentResolver());
        }

        protected Validator getValidator() {
            LocalValidatorFactoryBean localValidatorFactoryBean = new LocalValidatorFactoryBean();
            localValidatorFactoryBean.setProviderClass(HibernateValidator.class);
            localValidatorFactoryBean.setValidationMessageSource(this.messageSource);
            return localValidatorFactoryBean;
        }

        protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            converters.add((HttpMessageConverter<?>)this.mappingJackson2HttpMessageConverter);
            if (this.mappingJackson2XmlHttpMessageConverter != null) {
                converters.add((HttpMessageConverter<?>)this.mappingJackson2XmlHttpMessageConverter);
            }
            converters.add((HttpMessageConverter<?>)this.stringHttpMessageConverter);
        }

        @Bean
        public RequestMappingHandlerAdapter requestMappingHandlerAdapter() {
            RequestMappingHandlerAdapter adapter = super.requestMappingHandlerAdapter();
            adapter.setIgnoreDefaultModelOnRedirect(this.mvcProperties == null || this.mvcProperties.isIgnoreDefaultModelOnRedirect());
            if (this.serializationViewMappings != null) {
                adapter.setResponseBodyAdvice(Collections.singletonList(this.requestJsonViewResponseBodyAdvice()));
            }
            return adapter;
        }

        @Bean
        @ConditionalOnBean(value={SerializationViewMappings.class})
        public RequestJsonViewResponseBodyAdvice requestJsonViewResponseBodyAdvice() {
            return new RequestJsonViewResponseBodyAdvice(this.serializationViewMappings);
        }

        protected void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
            configurer.enable();
            super.configureDefaultServletHandling(configurer);
        }

        protected void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
            configurer.defaultContentType(MediaType.APPLICATION_JSON);
            configurer.favorParameter(true);
            configurer.parameterName("_format");
        }

        @Bean
        public RepositoryResourceMappings repositoryResourceMappings() {
            return new RepositoryResourceMappings(this.repositories());
        }

        protected RequestMappingHandlerMapping createRequestMappingHandlerMapping() {
            return new VersionRepositoryRestRequestMappingHandlerMapping(this.repositoryResourceMappings(), this.proxyPathMapper);
        }

        public RequestMappingHandlerMapping requestMappingHandlerMapping() {
            return super.requestMappingHandlerMapping();
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @Import(value={EnableWebMvcConfiguration.class})
    @EnableConfigurationProperties(value={WebMvcProperties.class, ResourceProperties.class})
    protected static class WebMvcAutoConfigurationAdapter
    extends WebMvcConfigurerAdapter {
        private static final Logger log = LoggerFactory.getLogger(WebMvcAutoConfigurationAdapter.class);
        @Autowired(required=false)
        private ResourceProperties resourceProperties = new ResourceProperties();
        @Autowired
        private WebMvcProperties mvcProperties = new WebMvcProperties();
        @Autowired
        private ListableBeanFactory beanFactory;
        @Autowired
        private HttpMessageConverters messageConverters;

        protected WebMvcAutoConfigurationAdapter() {
        }

        public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            converters.addAll(this.messageConverters.getConverters());
        }

        public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
            Long timeout = this.mvcProperties.getAsync().getRequestTimeout();
            if (timeout != null) {
                configurer.setDefaultTimeout(timeout.longValue());
            }
        }

        public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
            Map mediaTypes = this.mvcProperties.getMediaTypes();
            for (String extension : mediaTypes.keySet()) {
                configurer.mediaType(extension, (MediaType)mediaTypes.get(extension));
            }
        }

        @Bean
        @ConditionalOnMissingBean
        public InternalResourceViewResolver defaultViewResolver() {
            InternalResourceViewResolver resolver = new InternalResourceViewResolver();
            resolver.setPrefix(this.mvcProperties.getView().getPrefix());
            resolver.setSuffix(this.mvcProperties.getView().getSuffix());
            return resolver;
        }

        @Bean
        @ConditionalOnMissingBean(value={RequestContextListener.class, RequestContextFilter.class})
        public RequestContextFilter requestContextFilter() {
            return new OrderedRequestContextFilter();
        }

        @Bean
        @ConditionalOnBean(value={View.class})
        public BeanNameViewResolver beanNameViewResolver() {
            BeanNameViewResolver resolver = new BeanNameViewResolver();
            resolver.setOrder(0x7FFFFFF5);
            return resolver;
        }

        @Bean
        @ConditionalOnBean(value={ViewResolver.class})
        @ConditionalOnMissingBean(name={"viewResolver"}, value={ContentNegotiatingViewResolver.class})
        public ContentNegotiatingViewResolver viewResolver(BeanFactory beanFactory) {
            ContentNegotiatingViewResolver resolver = new ContentNegotiatingViewResolver();
            resolver.setContentNegotiationManager((ContentNegotiationManager)beanFactory.getBean(ContentNegotiationManager.class));
            resolver.setOrder(Integer.MIN_VALUE);
            return resolver;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.mvc", name={"locale"})
        public LocaleResolver localeResolver() {
            return new FixedLocaleResolver(this.mvcProperties.getLocale());
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.mvc", name={"date-format"})
        public Formatter<Date> dateFormatter() {
            return new DateFormatter(this.mvcProperties.getDateFormat());
        }

        public MessageCodesResolver getMessageCodesResolver() {
            if (this.mvcProperties.getMessageCodesResolverFormat() != null) {
                DefaultMessageCodesResolver resolver = new DefaultMessageCodesResolver();
                resolver.setMessageCodeFormatter((MessageCodeFormatter)this.mvcProperties.getMessageCodesResolverFormat());
                return resolver;
            }
            return null;
        }

        public void addFormatters(FormatterRegistry registry) {
            this.getBeansOfType(Converter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addConverter(arg_0));
            this.getBeansOfType(GenericConverter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addConverter(arg_0));
            this.getBeansOfType(Formatter.class).forEach(arg_0 -> ((FormatterRegistry)registry).addFormatter(arg_0));
            this.getBeansOfType(ConverterFactory.class).forEach(arg_0 -> ((FormatterRegistry)registry).addConverterFactory(arg_0));
        }

        private <T> Collection<T> getBeansOfType(Class<T> type) {
            return this.beanFactory.getBeansOfType(type).values();
        }

        public void addViewControllers(ViewControllerRegistry registry) {
            Resource page = this.resourceProperties.getWelcomePage();
            if (page != null) {
                log.info("Adding welcome page: " + page);
                registry.addViewController("/").setViewName("forward:index.html");
            }
        }
    }

    @Configuration
    @ConditionalOnBean(value={JavaMailSenderImpl.class, MailProperties.class})
    @ConditionalOnMissingBean(value={MailClient.class})
    protected static class MailSenderAutoConfiguration {
        @Autowired
        private MailProperties properties;
        @Autowired
        private JavaMailSenderImpl mailSender;

        protected MailSenderAutoConfiguration() {
        }

        @Bean
        public MailClient mailClient() {
            return new MailClient(this.mailSender, this.properties);
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"logging.logAspect.enabled"})
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={SpringProxy.class})
    protected static class LoggerConfiguration {
        @Autowired
        private ApplicationEventPublisher publisher;

        protected LoggerConfiguration() {
        }

        @Bean
        @Order(value=-2147483638)
        public LogAspect logAspect() {
            return new LogAspect(this.publisher);
        }

        @Bean
        public AbstractAuthenticationFailureListener abstractAuthenticationFailureListener() {
            return new AbstractAuthenticationFailureListener();
        }

        @Bean
        public AuthorizationFailureListener authorizationFailureListener() {
            return new AuthorizationFailureListener();
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @ComponentScan(basePackageClasses={BaseController.class})
    protected static class ControllerConfiguration {
        protected ControllerConfiguration() {
        }
    }
}

