/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.support;

import cn.bestwu.framework.data.annotation.DisableSelfRel;
import cn.bestwu.framework.event.ItemResourceEvent;
import cn.bestwu.framework.rest.controller.RepositoryEntityController;
import cn.bestwu.framework.rest.support.ETag;
import cn.bestwu.framework.rest.support.PersistentEntityResource;
import cn.bestwu.framework.util.ResourceUtil;
import cn.bestwu.framework.util.Sha1DigestUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.auditing.AuditableBeanWrapper;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.support.Repositories;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;

public class Response {
    @Value(value="${server.client-cache:true}")
    private boolean supportClientCache;
    @Value(value="${server.exact:false}")
    protected boolean exact;
    @Autowired
    private AuditableBeanWrapperFactory auditableBeanWrapperFactory;
    @Autowired
    private Repositories repositories;
    @Autowired
    protected ApplicationEventPublisher publisher;
    @Autowired(required=false)
    protected HttpServletRequest request;

    protected PersistentEntity<?, ?> getPersistentEntity(Class<?> domainType) {
        return this.repositories.getPersistentEntity(domainType);
    }

    protected HttpHeaders prepareHeaders(PersistentEntity<?, ?> entity, Object value) {
        HttpHeaders headers = ETag.from(entity, value, this.exact).addTo(new HttpHeaders());
        AuditableBeanWrapper wrapper = this.getAuditableBeanWrapper(value);
        if (wrapper == null) {
            return headers;
        }
        Calendar lastModifiedDate = wrapper.getLastModifiedDate();
        if (lastModifiedDate != null) {
            headers.setLastModified(lastModifiedDate.getTimeInMillis());
        }
        return Response.cacheControl(headers);
    }

    public static HttpHeaders noCache() {
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl("no-cache, no-store, max-age=0, must-revalidate");
        headers.setPragma("no-cache");
        headers.setExpires(-1L);
        return headers;
    }

    public static HttpHeaders cacheControl(HttpHeaders headers) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.setCacheControl("no-cache, must-revalidate");
        headers.setPragma("no-cache");
        headers.setExpires(-1L);
        return headers;
    }

    private AuditableBeanWrapper getAuditableBeanWrapper(Object source) {
        return this.auditableBeanWrapperFactory.getBeanWrapperFor(source);
    }

    protected ResponseEntity created(PersistentEntityResource<?> entityResource) {
        this.itemResourceHandle(entityResource);
        ResponseEntity.BodyBuilder created = this.noSelfRel(entityResource) ? ResponseEntity.status((HttpStatus)HttpStatus.CREATED) : ResponseEntity.created((URI)URI.create(entityResource.getLinks().get("self")));
        if (this.supportClientCache) {
            return ((ResponseEntity.BodyBuilder)created.headers(this.prepareHeaders(entityResource.getEntity(), entityResource.getContent()))).body(entityResource);
        }
        return ((ResponseEntity.BodyBuilder)created.headers(Response.noCache())).body(entityResource);
    }

    protected ResponseEntity updated(PersistentEntityResource<?> entityResource) {
        this.itemResourceHandle(entityResource);
        ResponseEntity.BodyBuilder location = ResponseEntity.ok();
        if (!this.noSelfRel(entityResource)) {
            location.location(URI.create(entityResource.getLinks().get("self")));
        }
        if (this.supportClientCache) {
            return ((ResponseEntity.BodyBuilder)location.headers(this.prepareHeaders(entityResource.getEntity(), entityResource.getContent()))).body(entityResource);
        }
        return ((ResponseEntity.BodyBuilder)location.headers(Response.noCache())).body(entityResource);
    }

    protected ResponseEntity noCache(Object object) {
        return this.ok(object, false);
    }

    protected ResponseEntity ok(Object object) {
        return this.ok(object, this.supportClientCache);
    }

    private ResponseEntity ok(Object resource, boolean supportClientCache) {
        if ("HEAD".equals(ResourceUtil.REQUEST_METHOD.get())) {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Link", this.request.getRequestURL().toString());
            return new ResponseEntity((MultiValueMap)headers, HttpStatus.NO_CONTENT);
        }
        if (resource instanceof PersistentEntityResource) {
            PersistentEntityResource persistentEntityResource = (PersistentEntityResource)resource;
            PersistentEntity<?, ?> persistentEntity = persistentEntityResource.getEntity();
            Object source = persistentEntityResource.getContent();
            Assert.notNull(source);
            this.itemResourceHandle(persistentEntityResource);
            if (source instanceof Page) {
                Page page = (Page)source;
                List content = page.getContent();
                if (!content.isEmpty()) {
                    ResourceConverter converter = this.getResourceConverter(persistentEntityResource, supportClientCache);
                    page = page.map((Converter)converter);
                    ResponseEntity.BodyBuilder bodyBuilder = converter.getBodyBuilder();
                    return bodyBuilder.body(persistentEntityResource.map(page));
                }
            } else if (source instanceof Iterable) {
                Iterable iterable = (Iterable)source;
                if (iterable.iterator().hasNext()) {
                    ResourceConverter converter = this.getResourceConverter(persistentEntityResource, supportClientCache);
                    ArrayList newContent = new ArrayList();
                    iterable.forEach(object -> newContent.add(converter.convert(object)));
                    ResponseEntity.BodyBuilder bodyBuilder = converter.getBodyBuilder();
                    return bodyBuilder.body(persistentEntityResource.map(newContent));
                }
            } else {
                if (supportClientCache) {
                    return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.prepareHeaders(persistentEntity, source))).body(resource);
                }
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(Response.noCache())).body(resource);
            }
        }
        if (supportClientCache) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(Response.cacheControl(null))).body(resource);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(Response.noCache())).body(resource);
    }

    private void itemResourceHandle(PersistentEntityResource<?> resource) {
        PersistentEntity<?, ?> persistentEntity = resource.getEntity();
        Object content = resource.getContent();
        if (content instanceof Iterable) {
            if (this.noSelfRel(resource)) {
                resource.add(this.getBaseLinkBuilder(ResourceUtil.getRepositoryBasePathName(persistentEntity.getType())).withSelfRel());
            }
        } else {
            this.publisher.publishEvent((ApplicationEvent)new ItemResourceEvent(content, resource));
            if (!persistentEntity.getType().isAnnotationPresent(DisableSelfRel.class) && this.noSelfRel(resource)) {
                resource.add(((ControllerLinkBuilder)this.getBaseLinkBuilder(ResourceUtil.getRepositoryBasePathName(persistentEntity.getType())).slash(this.getId(persistentEntity, content))).withSelfRel());
            }
        }
    }

    private boolean noSelfRel(PersistentEntityResource<?> resource) {
        return resource.getLinks() == null || resource.getLinks().get("self") == null;
    }

    protected Link getEntitySelfLink(Object content) {
        Class<?> sourceClass = content.getClass();
        if (ClassUtils.isCglibProxy((Object)content)) {
            sourceClass = sourceClass.getSuperclass();
        }
        PersistentEntity<?, ?> persistentEntity = this.getPersistentEntity(sourceClass);
        return ((ControllerLinkBuilder)this.getBaseLinkBuilder(ResourceUtil.getRepositoryBasePathName(persistentEntity.getType())).slash(this.getId(persistentEntity, content))).withSelfRel();
    }

    private ResourceConverter getResourceConverter(PersistentEntityResource<?> resource, boolean supportClientCache) {
        PersistentEntity<?, ?> entity = resource.getEntity();
        String repositoryBasePathName = ResourceUtil.getRepositoryBasePathName(entity.getType());
        ControllerLinkBuilder baseLinkBuilder = this.getBaseLinkBuilder(repositoryBasePathName);
        return new ResourceConverter(supportClientCache, entity, baseLinkBuilder);
    }

    protected ControllerLinkBuilder getBaseLinkBuilder(String resourceName) {
        return ControllerLinkBuilder.linkTo(RepositoryEntityController.class, (Object[])new Object[]{resourceName});
    }

    protected Object getId(PersistentEntity<?, ?> persistentEntity, Object entity) {
        return persistentEntity.getIdentifierAccessor(entity).getIdentifier();
    }

    protected ResponseEntity noContent() {
        return ResponseEntity.noContent().build();
    }

    private class ResourceConverter
    implements Converter<Object, PersistentEntityResource<?>> {
        private List<String> eTagValues = new ArrayList<String>();
        private List<Long> LastModifieds = new ArrayList<Long>();
        private boolean hasEtag = true;
        private boolean hasLastModified = true;
        private final boolean supportClientCache;
        private PersistentEntity<?, ?> persistentEntity = null;
        private ControllerLinkBuilder baseLinkBuilder = null;

        public ResourceConverter(boolean supportClientCache, PersistentEntity<?, ?> persistentEntity, ControllerLinkBuilder baseLinkBuilder) {
            this.supportClientCache = supportClientCache;
            this.persistentEntity = persistentEntity;
            this.baseLinkBuilder = baseLinkBuilder;
        }

        public PersistentEntityResource<?> convert(Object source) {
            if (this.supportClientCache) {
                if (this.hasEtag) {
                    String eTagValue = ETag.getETagValue(this.persistentEntity, source, Response.this.exact);
                    if (eTagValue == null) {
                        this.hasEtag = false;
                    } else {
                        this.eTagValues.add(eTagValue);
                    }
                }
                if (this.hasLastModified) {
                    AuditableBeanWrapper wrapper = Response.this.getAuditableBeanWrapper(source);
                    if (wrapper == null) {
                        this.hasLastModified = false;
                    } else {
                        Calendar lastModifiedDate = wrapper.getLastModifiedDate();
                        if (lastModifiedDate == null) {
                            this.hasLastModified = false;
                        } else {
                            this.LastModifieds.add(lastModifiedDate.getTimeInMillis());
                        }
                    }
                }
            }
            PersistentEntityResource<Object> resource = new PersistentEntityResource<Object>(source, this.persistentEntity, new Link[0]);
            Response.this.publisher.publishEvent((ApplicationEvent)new ItemResourceEvent(source, resource));
            if (!this.persistentEntity.getType().isAnnotationPresent(DisableSelfRel.class) && Response.this.noSelfRel(resource)) {
                resource.add(((ControllerLinkBuilder)this.baseLinkBuilder.slash(Response.this.getId(this.persistentEntity, source))).withSelfRel());
            }
            return resource;
        }

        public ResponseEntity.BodyBuilder getBodyBuilder() {
            if (this.supportClientCache) {
                HttpHeaders headers = new HttpHeaders();
                if (this.hasEtag) {
                    String eTagValue = "";
                    int size = this.eTagValues.size();
                    for (int i = 0; i < size; ++i) {
                        eTagValue = eTagValue.concat(this.eTagValues.get(i));
                        if (i == size - 1) continue;
                        eTagValue = eTagValue.concat("|");
                    }
                    eTagValue = "\"".concat(Sha1DigestUtil.shaHex(eTagValue)).concat("\"");
                    headers.setETag(eTagValue);
                }
                if (this.hasLastModified) {
                    this.LastModifieds.sort((x, y) -> x < y ? 1 : (Objects.equals(x, y) ? 0 : -1));
                    headers.setLastModified(this.LastModifieds.get(0).longValue());
                }
                return (ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(Response.cacheControl(headers));
            }
            return (ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(Response.noCache());
        }
    }
}

