/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.data.query.jpa;

import cn.bestwu.framework.data.annotation.HighLight;
import cn.bestwu.framework.data.query.LuceneSort;
import cn.bestwu.framework.data.query.QueryCarrier;
import cn.bestwu.framework.data.query.ResultHandler;
import cn.bestwu.framework.data.query.SearchRepository;
import cn.bestwu.framework.data.query.jpa.HighlightResultHandler;
import cn.bestwu.framework.data.query.jpa.JpaSearchFieldUtil;
import cn.bestwu.framework.event.QueryBuilderEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.lucene.search.Query;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.exception.EmptyQueryException;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class JpaSearchRepository
implements SearchRepository {
    private Map<Class, String[]> fieldsCache = new HashMap<Class, String[]>();
    private Map<Class, String[]> highlightFieldsCache = new HashMap<Class, String[]>();
    private final EntityManager entityManager;
    private final ApplicationEventPublisher publisher;

    public JpaSearchRepository(EntityManager entityManager, ApplicationEventPublisher publisher) {
        this.entityManager = entityManager;
        this.publisher = publisher;
    }

    private <T> String[] getSearchFields(Class<T> domainType) {
        String[] fields;
        if (this.fieldsCache.containsKey(domainType)) {
            fields = this.fieldsCache.get(domainType);
        } else {
            fields = JpaSearchFieldUtil.getAnnotationedFields(domainType, Field.class);
            if (fields.length == 0) {
                throw new RuntimeException("\u641c\u7d22\u7684\u7c7b\u578b" + domainType + "\u6ca1\u6709\u6807\u6ce8\u7d22\u5f15\u5b57\u6bb5,\u8bf7\u4f7f\u7528org.hibernate.search.annotations.Field\u6807\u6ce8");
            }
            this.fieldsCache.put(domainType, fields);
        }
        return fields;
    }

    private <T> String[] getHighLightFields(Class<T> domainType) {
        String[] highLightFields;
        if (this.highlightFieldsCache.containsKey(domainType)) {
            highLightFields = this.highlightFieldsCache.get(domainType);
        } else {
            highLightFields = JpaSearchFieldUtil.getAnnotationedFields(domainType, HighLight.class);
            if (highLightFields.length == 0) {
                highLightFields = this.getSearchFields(domainType);
            }
            this.highlightFieldsCache.put(domainType, highLightFields);
        }
        return highLightFields;
    }

    @Override
    public <T> Page search(Class<T> domainType, String keyword, Pageable pageable, ResultHandler resultHandler) {
        try {
            List result;
            FullTextQuery fullTextQuery;
            long totalSize;
            FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.entityManager);
            SearchFactory searchFactory = fullTextEntityManager.getSearchFactory();
            QueryBuilder queryBuilder = searchFactory.buildQueryBuilder().forEntity(domainType).get();
            Query luceneQuery = keyword.length() == 1 ? queryBuilder.keyword().wildcard().onFields(this.getSearchFields(domainType)).matching((Object)(keyword + "*")).createQuery() : (keyword.contains("*") || keyword.contains("?") ? queryBuilder.keyword().wildcard().onFields(this.getSearchFields(domainType)).matching((Object)keyword).createQuery() : queryBuilder.keyword().onFields(this.getSearchFields(domainType)).matching((Object)keyword).createQuery());
            QueryCarrier queryCarrier = new QueryCarrier(queryBuilder, luceneQuery, keyword);
            this.publisher.publishEvent((ApplicationEvent)new QueryBuilderEvent(queryCarrier, domainType));
            Query query = queryCarrier.getQuery();
            if (query != null) {
                luceneQuery = query;
            }
            if ((totalSize = (long)(fullTextQuery = fullTextEntityManager.createFullTextQuery(luceneQuery, new Class[]{domainType})).getResultSize()) > 0L) {
                Sort sort = pageable.getSort();
                if (sort != null && sort instanceof LuceneSort) {
                    fullTextQuery.setSort(((LuceneSort)sort).getSort());
                }
                fullTextQuery.setFirstResult(pageable.getOffset());
                fullTextQuery.setMaxResults(pageable.getPageSize());
                result = fullTextQuery.getResultList();
            } else {
                result = Collections.emptyList();
            }
            if (resultHandler != null) {
                if (resultHandler instanceof HighlightResultHandler) {
                    HighlightResultHandler highlightResultHandler = (HighlightResultHandler)resultHandler;
                    highlightResultHandler.setQuery(luceneQuery);
                    highlightResultHandler.setAnalyzer(searchFactory.getAnalyzer(domainType));
                    highlightResultHandler.setHighLightFields(this.getHighLightFields(domainType));
                    highlightResultHandler.setDomainType(domainType);
                }
                resultHandler.accept(result);
            }
            return new PageImpl(result, pageable, totalSize);
        }
        catch (EmptyQueryException ignored) {
            return new PageImpl(Collections.emptyList(), pageable, 0L);
        }
    }
}

