/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.aspect;

import cn.bestwu.framework.rest.support.PrincipalNamePutEvent;
import cn.bestwu.framework.rest.support.RequestJsonViewResponseBodyAdvice;
import cn.bestwu.framework.rest.support.Resource;
import cn.bestwu.framework.util.ResourceUtil;
import cn.bestwu.framework.util.StringUtil;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.http.server.ServletServerHttpRequest;

@Aspect
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private final String PUT_PARAMETER_MAP = "PUT_PARAMETER_MAP";
    private final String PRINCIPAL_NAME = "PRINCIPAL_NAME";
    public static final String REQUEST_METHOD = "REQUEST_METHOD";
    public static final String API_SIGNATURE = "API_SIGNATURE";
    public static final String REQUEST_VERSION = "REQUEST_VERSION";
    protected ApplicationEventPublisher publisher;
    @Autowired(required=false)
    protected HttpServletRequest request;
    @Autowired(required=false)
    private RequestJsonViewResponseBodyAdvice requestJsonViewResponseBodyAdvice;

    public LogAspect(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @AfterThrowing(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void afterThrowing() {
        Resource<String> source = new Resource<String>();
        this.publisher.publishEvent((ApplicationEvent)new PrincipalNamePutEvent(source));
        this.request.setAttribute("PRINCIPAL_NAME", (Object)source.getContent());
        this.request.setAttribute(API_SIGNATURE, (Object)ResourceUtil.API_SIGNATURE.get());
        this.request.setAttribute(REQUEST_VERSION, (Object)ResourceUtil.REQUEST_VERSION.get());
        this.request.setAttribute(REQUEST_METHOD, (Object)ResourceUtil.REQUEST_METHOD.get());
        if ("PUT".equals(this.request.getMethod())) {
            this.request.setAttribute("PUT_PARAMETER_MAP", (Object)this.request.getParameterMap());
        }
    }

    @AfterReturning(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)", returning="result")
    public void log(Object result) {
        if (log.isInfoEnabled()) {
            String resultStr;
            String principalName;
            String ipAddress = this.request.getRemoteAddr();
            String servletPath = (String)this.request.getAttribute("javax.servlet.forward.servlet_path");
            if (servletPath == null) {
                servletPath = this.request.getServletPath();
            }
            if ((principalName = (String)this.request.getAttribute("PRINCIPAL_NAME")) == null) {
                Resource<String> source = new Resource<String>();
                this.publisher.publishEvent((ApplicationEvent)new PrincipalNamePutEvent(source));
                principalName = source.getContent();
            }
            String requestMethod = ResourceUtil.REQUEST_METHOD.get();
            Map parameterMap = null;
            try {
                if ("PUT".equals(requestMethod)) {
                    parameterMap = (Map)this.request.getAttribute("PUT_PARAMETER_MAP");
                }
                if (parameterMap == null) {
                    parameterMap = this.request.getParameterMap();
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\u51fa\u9519", (Throwable)e);
                }
                parameterMap = null;
            }
            ServletServerHttpRequest servletServerHttpRequest = new ServletServerHttpRequest(this.request);
            HttpHeaders headers = servletServerHttpRequest.getHeaders();
            String MSG_CODE = "{} [{}] [{}] {} {} {} HEADERS[{}]HEADERSEND PARAMETERS[{}]PARAMETERSEND {}";
            principalName = principalName == null ? (this.request.getRemoteUser() == null ? "anonymousUser" : this.request.getRemoteUser()) : principalName;
            String requestSignature = ResourceUtil.API_SIGNATURE.get();
            boolean error = false;
            if (result instanceof ResponseEntity) {
                ResponseEntity responseEntity = (ResponseEntity)result;
                HttpStatus statusCode = responseEntity.getStatusCode();
                if (statusCode.is2xxSuccessful() || statusCode.is3xxRedirection()) {
                    if (log.isTraceEnabled()) {
                        Object body = responseEntity.getBody();
                        if (this.requestJsonViewResponseBodyAdvice != null) {
                            MappingJacksonValue mappingJacksonValue = new MappingJacksonValue(body);
                            this.requestJsonViewResponseBodyAdvice.beforeBodyWrite(mappingJacksonValue);
                            body = mappingJacksonValue;
                        }
                        resultStr = StringUtil.valueOf(body, true);
                    } else {
                        resultStr = statusCode.toString() + " " + statusCode.getReasonPhrase();
                    }
                } else {
                    resultStr = log.isDebugEnabled() ? "Error:\n" + StringUtil.valueOf(result, true) : "Error:" + StringUtil.valueOf(result);
                }
                error = statusCode.is5xxServerError();
            } else {
                resultStr = log.isTraceEnabled() ? String.valueOf(result) : StringUtil.subString(String.valueOf(result), 100);
            }
            if (log.isDebugEnabled()) {
                log.info("{} [{}] [{}] {} {} {}\nheaders\n{}\nparameters\n{}\n{}", new Object[]{ipAddress, StringUtil.subString(this.getUserAgent(), 220), principalName, requestMethod, requestSignature, servletPath, StringUtil.valueOf(headers, true), StringUtil.valueOf(parameterMap, true), resultStr});
            } else if (error) {
                log.error(MSG_CODE, new Object[]{ipAddress, StringUtil.subString(this.getUserAgent(), 220), principalName, requestMethod, requestSignature, servletPath, StringUtil.valueOf(headers), StringUtil.valueOf(parameterMap), resultStr});
            } else {
                log.info(MSG_CODE, new Object[]{ipAddress, StringUtil.subString(this.getUserAgent(), 220), principalName, requestMethod, requestSignature, servletPath, StringUtil.valueOf(headers), StringUtil.valueOf(parameterMap), resultStr});
            }
        }
    }

    public String getUserAgent() {
        Enumeration headers = this.request.getHeaders("user-agent");
        if (headers.hasMoreElements()) {
            return (String)headers.nextElement();
        }
        return null;
    }
}

