/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.controller;

import cn.bestwu.api.sign.ApiSign;
import cn.bestwu.framework.data.query.ResultHandler;
import cn.bestwu.framework.data.query.SearchRepository;
import cn.bestwu.framework.data.query.jpa.HighlightResultHandler;
import cn.bestwu.framework.data.query.jpa.JpaSearchRepository;
import cn.bestwu.framework.rest.annotation.RepositoryRestController;
import cn.bestwu.framework.rest.controller.BaseController;
import cn.bestwu.framework.rest.exception.ResourceNotFoundException;
import cn.bestwu.framework.rest.support.PersistentEntityResource;
import cn.bestwu.framework.rest.support.RootResourceInformation;
import java.lang.reflect.Method;
import org.hibernate.search.annotations.Indexed;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@ApiSign
@RepositoryRestController
@ConditionalOnBean(value={SearchRepository.class})
@RequestMapping(value={"/{repository}"})
public class RepositorySearchController
extends BaseController {
    @Autowired
    private SearchRepository searchRepository;
    @Autowired(required=false)
    private ResultHandler resultHandler;

    @RequestMapping(value={"/search/fulltext"}, method={RequestMethod.GET})
    public Object search(RootResourceInformation resourceInformation, String keyword, Pageable pageable, boolean highLight) throws NoSuchMethodException {
        if (this.searchRepository == null) {
            throw new ResourceNotFoundException();
        }
        Assert.hasText((String)keyword, (String)this.getText("param.notnull", "keyword"));
        Class<?> domainType = resourceInformation.getModelType();
        boolean isJpaSearchRepository = JpaSearchRepository.class.equals((Object)AopProxyUtils.ultimateTargetClass((Object)this.searchRepository));
        if (isJpaSearchRepository && !domainType.isAnnotationPresent(Indexed.class)) {
            throw new ResourceNotFoundException();
        }
        ResultHandler resultHandler = this.resultHandler;
        if (highLight) {
            if (resultHandler == null && isJpaSearchRepository) {
                resultHandler = new HighlightResultHandler();
            }
        } else {
            resultHandler = null;
        }
        Page page = this.searchRepository.search(domainType, keyword, pageable, resultHandler);
        Link selfRel = ControllerLinkBuilder.linkTo(RepositorySearchController.class, (Method)RepositorySearchController.class.getMethod("search", RootResourceInformation.class, String.class, Pageable.class, Boolean.TYPE), (Object[])new Object[]{resourceInformation.getPathName()}).withSelfRel();
        return this.ok(new PersistentEntityResource<Page>(page, resourceInformation.getEntity(), selfRel));
    }
}

