/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.mapping;

import cn.bestwu.framework.rest.annotation.RepositoryRestController;
import cn.bestwu.framework.rest.exception.ResourceNotFoundException;
import cn.bestwu.framework.rest.mapping.RepositoryResourceMappings;
import cn.bestwu.framework.rest.support.ProxyPathMapper;
import cn.bestwu.framework.rest.support.RepositoryResourceMetadata;
import cn.bestwu.framework.rest.support.ResourceType;
import cn.bestwu.framework.rest.support.Version;
import cn.bestwu.framework.util.ArrayUtil;
import cn.bestwu.framework.util.ResourceUtil;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.hateoas.core.AnnotationMappingDiscoverer;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class VersionRepositoryRestRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    public static final String REQUEST_REPOSITORY_BASE_PATH_NAME = "request_repository_base_path_name";
    public static final String REQUEST_REPOSITORY_SEARCH_NAME = "request_repository_search_name";
    public static final String REQUEST_REPOSITORY_RESOURCE_METADATA = "request_repository_resource_metadata";
    public static final String COLLECTION_LOOKUP_PATH_REGEX = "^/[^/]+/?$";
    private final String[] IGNORED_LOOKUP_PATH = new String[]{"/oauth/authorize", "/oauth/token", "/oauth/check_token", "/oauth/confirm_access", "/oauth/error"};
    private final RepositoryResourceMappings repositoryResourceMappings;
    private final ProxyPathMapper proxyPathMapper;
    private static AnnotationMappingDiscoverer DISCOVERER = new AnnotationMappingDiscoverer(RequestMapping.class);

    public VersionRepositoryRestRequestMappingHandlerMapping(RepositoryResourceMappings repositoryResourceMappings, ProxyPathMapper proxyPathMapper) {
        Assert.notNull((Object)repositoryResourceMappings);
        this.repositoryResourceMappings = repositoryResourceMappings;
        this.proxyPathMapper = proxyPathMapper;
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        String version = (String)request.getAttribute("REQUEST_VERSION");
        if (version == null) {
            Enumeration accept = request.getHeaders("Accept");
            while (accept.hasMoreElements()) {
                String s;
                String[] split;
                String element = (String)accept.nextElement();
                String[] stringArray = split = element.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n && !StringUtils.hasText((String)(version = MediaType.valueOf((String)(s = stringArray[i])).getParameter("version"))); ++i) {
                }
            }
            if (!StringUtils.hasText((String)version)) {
                version = request.getParameter("_version");
            }
            if (!StringUtils.hasText((String)version)) {
                version = "1.0";
            }
        }
        ResourceUtil.REQUEST_VERSION.set(version);
        String requestMethod = (String)request.getAttribute("REQUEST_METHOD");
        if (requestMethod == null) {
            requestMethod = request.getMethod();
        }
        ResourceUtil.REQUEST_METHOD.set(requestMethod);
        HandlerMethod handlerMethod = this.getHandlerMethod(lookupPath, request);
        String apiSignature = (String)request.getAttribute("API_SIGNATURE");
        if (apiSignature == null) {
            if (handlerMethod != null) {
                apiSignature = DISCOVERER.getMapping(handlerMethod.getMethod());
                if ("${server.error.path:${error.path:/error}}".equals(apiSignature)) {
                    apiSignature = (String)request.getAttribute("javax.servlet.forward.servlet_path");
                } else {
                    String searchName;
                    String repositoryBasePathName = (String)request.getAttribute(REQUEST_REPOSITORY_BASE_PATH_NAME);
                    if (repositoryBasePathName != null) {
                        apiSignature = apiSignature.replace("{repository}", repositoryBasePathName);
                    }
                    if ((searchName = (String)request.getAttribute(REQUEST_REPOSITORY_SEARCH_NAME)) != null) {
                        apiSignature = apiSignature.replace("{search}", searchName);
                    }
                }
                apiSignature = request.getMethod().toLowerCase() + apiSignature.replaceAll("[{}]", "").replace("/", "_");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("\u8bf7\u6c42\u7b7e\u540d\uff1a" + apiSignature));
                }
            } else {
                if (lookupPath.endsWith("/")) {
                    lookupPath = lookupPath.substring(0, lookupPath.length() - 1);
                }
                apiSignature = lookupPath;
                apiSignature = request.getMethod().toLowerCase() + apiSignature.replaceAll("[{}]", "").replace("/", "_");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("\u8bf7\u6c42\u7b7e\u540d\uff1a" + apiSignature));
                }
                request.setAttribute("API_SIGNATURE", (Object)apiSignature);
            }
        }
        ResourceUtil.API_SIGNATURE.set(apiSignature);
        return handlerMethod;
    }

    private HandlerMethod getHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        if (this.proxyPathMapper != null) {
            lookupPath = this.proxyPathMapper.getProxyPath(lookupPath);
        }
        if (ArrayUtil.contains(this.IGNORED_LOOKUP_PATH, lookupPath)) {
            return null;
        }
        HandlerMethod handlerMethod = super.lookupHandlerMethod(lookupPath, request);
        if (handlerMethod == null) {
            return null;
        }
        String basePathName = VersionRepositoryRestRequestMappingHandlerMapping.getBasePathName(lookupPath);
        if (!StringUtils.hasText((String)basePathName)) {
            return handlerMethod;
        }
        request.setAttribute(REQUEST_REPOSITORY_BASE_PATH_NAME, (Object)basePathName);
        Class beanType = handlerMethod.getBeanType();
        if (!beanType.isAnnotationPresent(RepositoryRestController.class)) {
            return handlerMethod;
        }
        RepositoryResourceMetadata repositoryResourceMetadata = this.repositoryResourceMappings.getRepositoryResourceMetadata(basePathName);
        request.setAttribute(REQUEST_REPOSITORY_RESOURCE_METADATA, (Object)repositoryResourceMetadata);
        if (repositoryResourceMetadata != null) {
            String SEARCH_LOOKUP_PATH_REGEX = "^/[^/]+/search(/([^/]+))?/?$";
            if (lookupPath.matches(SEARCH_LOOKUP_PATH_REGEX)) {
                String search = lookupPath.replaceAll(SEARCH_LOOKUP_PATH_REGEX, "$2");
                request.setAttribute(REQUEST_REPOSITORY_SEARCH_NAME, (Object)search);
                return handlerMethod;
            }
            if (repositoryResourceMetadata.isExported()) {
                ResourceType resourceType = null;
                String ITEM_LOOKUP_PATH_REGEX = "^/[^/]+/[^/]+/?$";
                if (lookupPath.matches(ITEM_LOOKUP_PATH_REGEX)) {
                    resourceType = ResourceType.ITEM;
                } else if (lookupPath.matches(COLLECTION_LOOKUP_PATH_REGEX)) {
                    resourceType = ResourceType.COLLECTION;
                }
                repositoryResourceMetadata.verifySupportedMethod(HttpMethod.valueOf((String)request.getMethod()), resourceType);
                return handlerMethod;
            }
            throw new ResourceNotFoundException(lookupPath);
        }
        return null;
    }

    public static String getBasePathName(String lookupPath) {
        int secondSlashIndex = lookupPath.indexOf(47, lookupPath.startsWith("/") ? 1 : 0);
        boolean noSecondSlashIndex = secondSlashIndex == -1;
        return noSecondSlashIndex ? lookupPath.substring(1) : lookupPath.substring(1, secondSlashIndex);
    }

    protected HandlerMethod handleNoMatch(Set<RequestMappingInfo> requestMappingInfos, String lookupPath, HttpServletRequest request) throws ServletException {
        return null;
    }

    protected Comparator<RequestMappingInfo> getMappingComparator(HttpServletRequest request) {
        return (info1, info2) -> {
            int result = this.versionCompareTo(this.getVersions(info1.getProducesCondition().getProducibleMediaTypes()), this.getVersions(info2.getProducesCondition().getProducibleMediaTypes()), request);
            if (result != 0) {
                return result;
            }
            return info1.compareTo(info2, request);
        };
    }

    private List<String> getVersions(Set<MediaType> mediaTypes) {
        return mediaTypes.stream().map(mediaType -> mediaType.getParameter("version")).filter(StringUtils::hasText).collect(Collectors.toList());
    }

    private int versionCompareTo(List<String> me, List<String> other, HttpServletRequest request) {
        if (me.isEmpty()) {
            me.add("1.0");
        }
        if (other.isEmpty()) {
            other.add("1.0");
        }
        Comparator comparator = Version::compareVersion;
        me.sort(comparator);
        other.sort(comparator);
        String acceptedVersion = ResourceUtil.REQUEST_VERSION.get();
        int thisIndex = this.equalVersion(me, acceptedVersion);
        int otherIndex = this.equalVersion(other, acceptedVersion);
        int result = this.compareMatchingMediaTypes(me, thisIndex, other, otherIndex);
        if (result != 0) {
            return result;
        }
        thisIndex = this.includedVersion(me, acceptedVersion);
        result = this.compareMatchingMediaTypes(me, thisIndex, other, otherIndex = this.includedVersion(other, acceptedVersion));
        if (result != 0) {
            return result;
        }
        return 0;
    }

    private int compareMatchingMediaTypes(List<String> versions1, int index1, List<String> versions2, int index2) {
        int result = 0;
        if (index1 != index2) {
            result = index2 - index1;
        } else if (index1 != -1) {
            String version2;
            String version1 = versions1.get(index1);
            result = Version.compareVersion(version1, version2 = versions2.get(index2));
            result = result != 0 ? result : version1.compareTo(version2);
        }
        return result;
    }

    private int equalVersion(List<String> versions, String acceptedVersion) {
        for (int i = 0; i < versions.size(); ++i) {
            String currentVersion = versions.get(i);
            if (!Version.equals(acceptedVersion, currentVersion)) continue;
            return i;
        }
        return -1;
    }

    private int includedVersion(List<String> versions, String acceptedVersion) {
        for (int i = 0; i < versions.size(); ++i) {
            String currentVersion = versions.get(i);
            if (!Version.included(acceptedVersion, currentVersion)) continue;
            return i;
        }
        return -1;
    }
}

