/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.resolver;

import cn.bestwu.framework.rest.mapping.RepositoryResourceMappings;
import cn.bestwu.framework.rest.support.RepositoryResourceMetadata;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class RepositoryResourceMetadataHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final RepositoryResourceMappings repositoryResourceMappings;

    public RepositoryResourceMetadataHandlerMethodArgumentResolver(RepositoryResourceMappings repositoryResourceMappings) {
        this.repositoryResourceMappings = repositoryResourceMappings;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return ClassUtils.isAssignable((Class)parameter.getParameterType(), RepositoryInformation.class);
    }

    public RepositoryResourceMetadata resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest nativeRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        String requestRepositoryResourceMetadataKey = "request_repository_resource_metadata";
        String requestRepositoryBasePathNameKey = "request_repository_base_path_name";
        RepositoryResourceMetadata repositoryResourceMetadata = (RepositoryResourceMetadata)nativeRequest.getAttribute(requestRepositoryResourceMetadataKey);
        String repositoryBasePathName = (String)nativeRequest.getAttribute(requestRepositoryBasePathNameKey);
        if (repositoryResourceMetadata == null) {
            repositoryResourceMetadata = this.repositoryResourceMappings.getRepositoryResourceMetadata(repositoryBasePathName);
        }
        if (repositoryBasePathName != null && repositoryResourceMetadata == null) {
            throw new IllegalArgumentException(String.format("Could not resolve repository metadata for %s.", repositoryBasePathName));
        }
        nativeRequest.setAttribute(requestRepositoryResourceMetadataKey, (Object)repositoryResourceMetadata);
        return repositoryResourceMetadata;
    }
}

