/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.resolver;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

public class StandardServletMultipartResolver
implements MultipartResolver {
    private static final Logger log = LoggerFactory.getLogger(StandardServletMultipartResolver.class);
    private boolean resolveLazily = false;

    public void setResolveLazily(boolean resolveLazily) {
        this.resolveLazily = resolveLazily;
    }

    public boolean isMultipart(HttpServletRequest request) {
        String method = request.getMethod();
        if (RequestMethod.POST.name().equals(method) || RequestMethod.PUT.name().equals(method)) {
            String contentType = request.getContentType();
            return contentType != null && contentType.toLowerCase().startsWith("multipart/");
        }
        return false;
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        return new StandardMultipartHttpServletRequest(request, this.resolveLazily);
    }

    public void cleanupMultipart(MultipartHttpServletRequest request) {
        block2: {
            try {
                request.getParts().stream().filter(part -> request.getFile(part.getName()) != null).forEach(part -> {
                    block2: {
                        try {
                            part.delete();
                        }
                        catch (Exception ex) {
                            if (!log.isWarnEnabled()) break block2;
                            log.warn("Failed to perform cleanup of multipart items", (Throwable)ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("Failed to perform cleanup of multipart items", (Throwable)ex);
            }
        }
    }
}

