/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.util;

import cn.bestwu.framework.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;

public class HtmlUtil {
    public static String subParserHtml(String inputString, int length) {
        if (inputString == null) {
            return null;
        }
        String subHtml = HtmlUtil.parserHtmlRemoveBlank(inputString);
        return StringUtil.subString(subHtml, length);
    }

    public static String subParserHtmlWithEllipsis(String inputString, int length) {
        if (inputString == null) {
            return null;
        }
        String subHtml = HtmlUtil.parserHtmlRemoveBlank(inputString);
        return StringUtil.subStringWithEllipsis(subHtml, length);
    }

    public static String parserHtml(String inputString) {
        if (inputString == null) {
            return null;
        }
        try {
            int count;
            StringBuilder sb = new StringBuilder();
            HTMLStripCharFilter htmlscript = new HTMLStripCharFilter((Reader)new StringReader(inputString));
            char[] buffer = new char[10240];
            while ((count = htmlscript.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, count));
            }
            htmlscript.close();
            return sb.toString();
        }
        catch (IOException e) {
            return inputString;
        }
    }

    public static String parserHtmlRemoveBlank(String inputString) {
        if (inputString == null) {
            return null;
        }
        try {
            int count;
            StringBuilder sb = new StringBuilder();
            HTMLStripCharFilter htmlscript = new HTMLStripCharFilter((Reader)new StringReader(inputString));
            NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
            builder.add("\r", "");
            builder.add("\t", "");
            builder.add("\n", "");
            builder.add(" ", "");
            MappingCharFilter cs = new MappingCharFilter(builder.build(), (Reader)htmlscript);
            char[] buffer = new char[10240];
            while ((count = cs.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, count));
            }
            cs.close();
            return sb.toString();
        }
        catch (IOException e) {
            return inputString;
        }
    }
}

