/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.config;

import cn.bestwu.framework.rest.aspect.LogAspect;
import cn.bestwu.framework.rest.config.MessageSourceConfiguration;
import cn.bestwu.framework.rest.controller.BaseController;
import cn.bestwu.framework.rest.converter.DefaultElementMixIn;
import cn.bestwu.framework.rest.converter.PageMixIn;
import cn.bestwu.framework.rest.filter.AuthenticationFailureListener;
import cn.bestwu.framework.rest.filter.AuthorizationFailureListener;
import cn.bestwu.framework.rest.filter.OrderedHttpPutFormContentFilter;
import cn.bestwu.framework.rest.filter.ThreadLocalCleanFilter;
import cn.bestwu.framework.rest.mapping.RepositoryResourceMappings;
import cn.bestwu.framework.rest.mapping.SerializationViewMappings;
import cn.bestwu.framework.rest.mapping.VersionRepositoryRestRequestMappingHandlerMapping;
import cn.bestwu.framework.rest.resolver.DomainMethodArgumentResolver;
import cn.bestwu.framework.rest.resolver.ETagArgumentResolver;
import cn.bestwu.framework.rest.resolver.QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver;
import cn.bestwu.framework.rest.resolver.QuerydslPredicateArgumentResolver;
import cn.bestwu.framework.rest.resolver.RepositoryResourceMetadataHandlerMethodArgumentResolver;
import cn.bestwu.framework.rest.resolver.ResourceMethodArgumentResolver;
import cn.bestwu.framework.rest.resolver.RootResourceInformationHandlerMethodArgumentResolver;
import cn.bestwu.framework.rest.resolver.StandardServletMultipartResolver;
import cn.bestwu.framework.rest.support.BaseErrorAttributes;
import cn.bestwu.framework.rest.support.MailClient;
import cn.bestwu.framework.rest.support.ProxyPathMapper;
import cn.bestwu.framework.rest.support.RequestJsonViewResponseBodyAdvice;
import cn.bestwu.framework.rest.support.UnwrappingRepositoryInvokerFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.aop.SpringProxy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.WebMvcRegistrationsAdapter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.Page;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.querydsl.binding.FixQuerydslPredicateBuilder;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.repository.support.DefaultRepositoryInvokerFactory;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.MediaType;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.web.filter.HttpPutFormContentFilter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@ConditionalOnWebApplication
@Import(value={MessageSourceConfiguration.class})
public class RestMvcConfiguration {
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public Module defaultModule() {
        SimpleModule module = new SimpleModule();
        module.setMixInAnnotation(Page.class, PageMixIn.class);
        module.setMixInAnnotation(Object.class, DefaultElementMixIn.class);
        return module;
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorAttributes.class}, search=SearchStrategy.CURRENT)
    public BaseErrorAttributes errorAttributes() {
        return new BaseErrorAttributes();
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpPutFormContentFilter.class})
    public OrderedHttpPutFormContentFilter httpFormContentFilterRegistration() {
        return new OrderedHttpPutFormContentFilter();
    }

    @Bean
    public ThreadLocalCleanFilter threadLocalCleanFilter() {
        return new ThreadLocalCleanFilter();
    }

    @Bean
    public MultipartResolver multipartResolver() {
        StandardServletMultipartResolver standardServletMultipartResolver = new StandardServletMultipartResolver();
        standardServletMultipartResolver.setResolveLazily(true);
        return standardServletMultipartResolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={Repositories.class})
    public Repositories repositories() {
        return new Repositories((ListableBeanFactory)this.applicationContext);
    }

    @Bean
    public RepositoryResourceMappings repositoryResourceMappings() {
        return new RepositoryResourceMappings(this.repositories());
    }

    @Configuration
    @ConditionalOnWebApplication
    protected static class WebMvcRegistrationsConfig
    extends WebMvcRegistrationsAdapter {
        @Autowired
        private RepositoryResourceMappings repositoryResourceMappings;
        @Autowired(required=false)
        private ProxyPathMapper proxyPathMapper;

        protected WebMvcRegistrationsConfig() {
        }

        public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
            return new VersionRepositoryRestRequestMappingHandlerMapping(this.repositoryResourceMappings, this.proxyPathMapper);
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    protected static class RequestMappingHandlerAdapterConfig
    implements InitializingBean {
        @Autowired(required=false)
        private SerializationViewMappings serializationViewMappings;
        @Autowired
        private RequestMappingHandlerAdapter requestMappingHandlerAdapter;

        protected RequestMappingHandlerAdapterConfig() {
        }

        @Bean
        @ConditionalOnBean(value={SerializationViewMappings.class})
        public RequestJsonViewResponseBodyAdvice requestJsonViewResponseBodyAdvice() {
            return new RequestJsonViewResponseBodyAdvice(this.serializationViewMappings);
        }

        public void afterPropertiesSet() throws Exception {
            if (this.serializationViewMappings != null) {
                this.requestMappingHandlerAdapter.setResponseBodyAdvice(Collections.singletonList(this.requestJsonViewResponseBodyAdvice()));
            }
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    protected static class CustomWebMvcConfiguration
    extends WebMvcConfigurerAdapter {
        @Autowired
        private StringHttpMessageConverter stringHttpMessageConverter;
        @Autowired
        private Repositories repositories;
        @Autowired
        private RepositoryResourceMappings repositoryResourceMappings;
        @Autowired
        private FormattingConversionService conversionService;
        @Autowired
        protected ApplicationEventPublisher publisher;
        @Autowired
        private MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter;
        @Autowired(required=false)
        private MappingJackson2XmlHttpMessageConverter mappingJackson2XmlHttpMessageConverter;

        protected CustomWebMvcConfiguration() {
        }

        @Bean
        public RepositoryInvokerFactory repositoryInvokerFactory() {
            return new UnwrappingRepositoryInvokerFactory((RepositoryInvokerFactory)new DefaultRepositoryInvokerFactory(this.repositories, (ConversionService)this.conversionService));
        }

        @Lazy
        @Bean
        public QuerydslBindingsFactory querydslBindingsFactory() {
            return new QuerydslBindingsFactory((EntityPathResolver)SimpleEntityPathResolver.INSTANCE);
        }

        @Lazy
        @Bean
        public FixQuerydslPredicateBuilder querydslPredicateBuilder() {
            return new FixQuerydslPredicateBuilder((ConversionService)this.conversionService, this.querydslBindingsFactory().getEntityPathResolver());
        }

        @Bean
        public RepositoryResourceMetadataHandlerMethodArgumentResolver repositoryResourceMetadataHandlerMethodArgumentResolver() {
            return new RepositoryResourceMetadataHandlerMethodArgumentResolver(this.repositoryResourceMappings);
        }

        @Bean
        public RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver() {
            if (QueryDslUtils.QUERY_DSL_PRESENT) {
                return new QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver(this.repositories, this.repositoryInvokerFactory(), this.repositoryResourceMetadataHandlerMethodArgumentResolver(), this.querydslPredicateBuilder(), this.querydslBindingsFactory(), this.publisher);
            }
            return new RootResourceInformationHandlerMethodArgumentResolver(this.repositoryInvokerFactory(), this.repositoryResourceMetadataHandlerMethodArgumentResolver());
        }

        private List<AbstractJackson2HttpMessageConverter> messageConverters() {
            ArrayList<AbstractJackson2HttpMessageConverter> messageConverters = new ArrayList<AbstractJackson2HttpMessageConverter>(2);
            messageConverters.add((AbstractJackson2HttpMessageConverter)this.mappingJackson2HttpMessageConverter);
            if (this.mappingJackson2XmlHttpMessageConverter != null) {
                messageConverters.add((AbstractJackson2HttpMessageConverter)this.mappingJackson2XmlHttpMessageConverter);
            }
            return messageConverters;
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.add(this.repoRequestArgumentResolver());
            argumentResolvers.add(new DomainMethodArgumentResolver(this.repositoryInvokerFactory(), this.messageConverters()));
            argumentResolvers.add(new ResourceMethodArgumentResolver(this.repositoryResourceMetadataHandlerMethodArgumentResolver(), this.repositoryInvokerFactory(), this.messageConverters()));
            if (QueryDslUtils.QUERY_DSL_PRESENT) {
                argumentResolvers.add(0, new QuerydslPredicateArgumentResolver(this.querydslBindingsFactory(), this.querydslPredicateBuilder()));
            }
            argumentResolvers.add(new ETagArgumentResolver());
        }

        public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
            configurer.defaultContentType(MediaType.APPLICATION_JSON);
            configurer.favorParameter(true);
            configurer.parameterName("_format");
        }
    }

    @Configuration
    @ConditionalOnBean(value={JavaMailSenderImpl.class, MailProperties.class})
    @ConditionalOnMissingBean(value={MailClient.class})
    protected static class MailSenderAutoConfiguration {
        @Autowired
        private MailProperties properties;
        @Autowired
        private JavaMailSenderImpl mailSender;

        protected MailSenderAutoConfiguration() {
        }

        @Bean
        public MailClient mailClient() {
            return new MailClient(this.mailSender, this.properties);
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"logging.logAspect.enabled"})
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={SpringProxy.class})
    protected static class LoggerConfiguration {
        @Autowired
        private ApplicationEventPublisher publisher;

        protected LoggerConfiguration() {
        }

        @Bean
        @Order(value=-2147483638)
        public LogAspect logAspect() {
            return new LogAspect(this.publisher);
        }

        @Configuration
        @ConditionalOnProperty(value={"logging.logAspect.enabled"})
        @ConditionalOnWebApplication
        @ConditionalOnClass(value={AbstractAuthenticationFailureEvent.class})
        protected static class FailureListener {
            protected FailureListener() {
            }

            @Bean
            public AuthenticationFailureListener authenticationFailureListener() {
                return new AuthenticationFailureListener();
            }

            @Bean
            public AuthorizationFailureListener authorizationFailureListener() {
                return new AuthorizationFailureListener();
            }
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @ComponentScan(basePackageClasses={BaseController.class})
    protected static class ControllerConfiguration {
        protected ControllerConfiguration() {
        }
    }
}

