/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.resolver;

import cn.bestwu.framework.rest.resolver.DomainMethodArgumentResolver;
import cn.bestwu.framework.rest.resolver.RepositoryResourceMetadataHandlerMethodArgumentResolver;
import cn.bestwu.framework.rest.support.PersistentEntityResource;
import cn.bestwu.framework.rest.support.RepositoryResourceMetadata;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.hateoas.Link;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ResourceMethodArgumentResolver
extends DomainMethodArgumentResolver {
    private final RepositoryResourceMetadataHandlerMethodArgumentResolver resourceMetadataResolver;

    public ResourceMethodArgumentResolver(RepositoryResourceMetadataHandlerMethodArgumentResolver resourceMetadataResolver, RepositoryInvokerFactory invokerFactory, List<AbstractJackson2HttpMessageConverter> messageConverters) {
        super(invokerFactory, messageConverters);
        this.resourceMetadataResolver = resourceMetadataResolver;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return PersistentEntityResource.class.isAssignableFrom(parameter.getParameterType());
    }

    @Override
    public PersistentEntityResource<?> resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        RepositoryResourceMetadata resourceMetadata = this.resourceMetadataResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        if (resourceMetadata == null) {
            return null;
        }
        Class<?> domainType = resourceMetadata.getModelType();
        return new PersistentEntityResource<Object>(this.resolveModel(parameter, mavContainer, webRequest, binderFactory, domainType), resourceMetadata.getEntity(), new Link[0]);
    }
}

