/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.data.validator;

import cn.bestwu.framework.data.validator.ReversePattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ReversePatternValidator
implements ConstraintValidator<ReversePattern, CharSequence> {
    private static final Log log = LoggerFactory.make();
    private Pattern pattern;

    public void initialize(ReversePattern parameters) {
        ReversePattern.Flag[] flags = parameters.flags();
        int intFlag = 0;
        for (ReversePattern.Flag flag : flags) {
            intFlag |= flag.getValue();
        }
        try {
            this.pattern = Pattern.compile(parameters.regexp(), intFlag);
        }
        catch (PatternSyntaxException e) {
            throw log.getInvalidRegularExpressionException(e);
        }
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        Matcher m = this.pattern.matcher(value);
        return !m.matches();
    }
}

