/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.support;

import cn.bestwu.framework.rest.exception.ETagDoesntMatchException;
import cn.bestwu.framework.util.Sha1DigestUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.serializer.DefaultSerializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class ETag {
    private static final Logger log = LoggerFactory.getLogger(ETag.class);
    public static final ETag NO_ETAG = new ETag(null);
    private final String value;
    private static final Serializer<Object> serializer = new DefaultSerializer();

    private ETag(String value) {
        this.value = StringUtils.trimTrailingCharacter((String)StringUtils.trimLeadingCharacter((String)value, (char)'\"'), (char)'\"');
    }

    public static ETag from(String value) {
        return value == null ? NO_ETAG : new ETag(value);
    }

    public static ETag from(PersistentEntity<?, ?> entity, Object bean, boolean exact) {
        return ETag.from(ETag.getETagValue(entity, bean, exact));
    }

    public static String getETagValue(PersistentEntity<?, ?> entity, Object bean, boolean exact) {
        Assert.notNull((Object)bean, (String)"Target bean must not be null!");
        if (exact || entity == null) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(1024);
            try {
                serializer.serialize(bean, (OutputStream)byteStream);
                return Sha1DigestUtil.shaHex(new String(byteStream.toByteArray()));
            }
            catch (Throwable ex) {
                log.error("Failed to serialize object using " + serializer.getClass().getSimpleName(), ex);
                return null;
            }
        }
        if (!entity.hasVersionProperty()) {
            return null;
        }
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(bean);
        String versionInfo = String.valueOf(accessor.getProperty(entity.getVersionProperty()));
        String idInfo = String.valueOf(accessor.getProperty(entity.getIdProperty()));
        return idInfo + ':' + versionInfo;
    }

    public void verify(PersistentEntity<?, ?> entity, Object target, boolean exact) {
        if (this == NO_ETAG || target == null) {
            return;
        }
        if (!this.equals(ETag.from(entity, target, exact))) {
            throw new ETagDoesntMatchException(target, this);
        }
    }

    public HttpHeaders addTo(HttpHeaders headers) {
        Assert.notNull((Object)headers, (String)"HttpHeaders must not be null!");
        String stringValue = this.toString();
        if (stringValue == null) {
            return headers;
        }
        headers.setETag(stringValue);
        return headers;
    }

    public String toString() {
        return this.value == null ? null : "\"".concat(Sha1DigestUtil.shaHex(this.value)).concat("\"");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ETag)) {
            return false;
        }
        ETag that = (ETag)obj;
        return ObjectUtils.nullSafeEquals((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

