/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.support;

import cn.bestwu.framework.rest.support.Resource;
import cn.bestwu.framework.util.ArrayUtil;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.hateoas.Link;

public class SimpleResource<T>
extends Resource<T> {
    private static final long serialVersionUID = 1498416512071480218L;
    @JsonView(value={Object.class})
    private Map<String, String> links;

    public SimpleResource(T content, Link ... links) {
        super(content);
        if (ArrayUtil.isNotEmpty(links)) {
            this.links = new HashMap<String, String>();
            Arrays.stream(links).forEach(link -> this.links.put(link.getRel(), link.getHref()));
        }
    }

    protected SimpleResource(T content, Map<String, String> links) {
        super(content);
        this.links = links;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    public void add(Link ... links) {
        if (this.links == null) {
            this.links = new HashMap<String, String>();
        }
        Arrays.stream(links).forEach(link -> this.links.put(link.getRel(), link.getHref()));
    }
}

