/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.data.query.jpa;

import cn.bestwu.framework.util.StringUtil;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class JpaSearchFieldUtil {
    private static final Logger log = LoggerFactory.getLogger(JpaSearchFieldUtil.class);

    public static <T> String[] getAnnotationedFields(Class<T> modelType, Class<? extends Annotation> AnnotationType2) {
        HashSet<String> fields = new HashSet<String>();
        JpaSearchFieldUtil.getAnnotationedFields(fields, modelType, AnnotationType2, null);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u627e\u5230" + AnnotationType2 + "\u6ce8\u89e3\u7684\u5b57\u6bb5\uff1a" + fields);
        }
        return fields.toArray(new String[fields.size()]);
    }

    private static <T> void getAnnotationedFields(Set<String> fields, Class<T> modelType, Class<? extends Annotation> AnnotationType2, String parentFieldName) {
        Arrays.stream(modelType.getDeclaredFields()).forEach(field -> JpaSearchFieldUtil.addAnnotationedFields(fields, field, AnnotationType2, parentFieldName));
        Arrays.stream(BeanUtils.getPropertyDescriptors(modelType)).forEach(propertyDescriptor -> JpaSearchFieldUtil.addAnnotationedPropertys(fields, propertyDescriptor, AnnotationType2, parentFieldName));
    }

    private static void addAnnotationedPropertys(Set<String> fields, PropertyDescriptor propertyDescriptor, Class<? extends Annotation> annotationType, String parentFieldName) {
        IndexedEmbedded annotation;
        Method readMethod;
        String propertyName = propertyDescriptor.getName();
        if (parentFieldName != null) {
            propertyName = parentFieldName + "." + propertyName;
        }
        if ((readMethod = propertyDescriptor.getReadMethod()).isAnnotationPresent(annotationType)) {
            if (annotationType.equals(org.hibernate.search.annotations.Field.class)) {
                org.hibernate.search.annotations.Field fieldAnnotation = readMethod.getAnnotation(org.hibernate.search.annotations.Field.class);
                FieldBridge bridge = fieldAnnotation.bridge();
                if (Void.TYPE.equals(bridge.impl())) {
                    fields.add(propertyName);
                }
            } else {
                fields.add(propertyName);
            }
        } else if (readMethod.isAnnotationPresent(IndexedEmbedded.class) && (annotation = readMethod.getAnnotation(IndexedEmbedded.class)).depth() > StringUtil.countSubString(propertyName, ".")) {
            JpaSearchFieldUtil.getAnnotationedFields(fields, readMethod.getReturnType(), annotationType, propertyName);
        }
    }

    private static void addAnnotationedFields(Set<String> fields, Field field, Class<? extends Annotation> annotationType, String parentFieldName) {
        IndexedEmbedded annotation;
        String fieldName = field.getName();
        if (parentFieldName != null) {
            fieldName = parentFieldName + "." + fieldName;
        }
        if (field.isAnnotationPresent(annotationType)) {
            if (annotationType.equals(org.hibernate.search.annotations.Field.class)) {
                org.hibernate.search.annotations.Field fieldAnnotation = field.getAnnotation(org.hibernate.search.annotations.Field.class);
                FieldBridge bridge = fieldAnnotation.bridge();
                if (Void.TYPE.equals(bridge.impl())) {
                    fields.add(fieldName);
                }
            } else {
                fields.add(fieldName);
            }
        } else if (field.isAnnotationPresent(IndexedEmbedded.class) && (annotation = field.getAnnotation(IndexedEmbedded.class)).depth() > StringUtil.countSubString(fieldName, ".")) {
            JpaSearchFieldUtil.getAnnotationedFields(fields, field.getType(), annotationType, fieldName);
        }
    }
}

