/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.filter;

import cn.bestwu.framework.util.StringUtil;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.ServletServerHttpRequest;

public abstract class AuthenticationFailureListener<T extends ApplicationEvent>
implements ApplicationListener<T> {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationFailureListener.class);
    @Autowired(required=false)
    protected HttpServletRequest request;
    @Autowired(required=false)
    protected HttpServletResponse response;

    public void onApplicationEvent(T event) {
        if (log.isInfoEnabled()) {
            String ipAddress = this.request.getRemoteAddr();
            String servletPath = (String)this.request.getAttribute("javax.servlet.forward.servlet_path");
            if (servletPath == null) {
                servletPath = this.request.getServletPath();
            }
            String requestMethod = this.request.getMethod();
            Map parameterMap = this.request.getParameterMap();
            ServletServerHttpRequest servletServerHttpRequest = new ServletServerHttpRequest(this.request);
            HttpHeaders headers = servletServerHttpRequest.getHeaders();
            String MSG_CODE = "{} [{}] [{}] {} {} {} HEADERS[{}]HEADERSEND PARAMETERS[{}]PARAMETERSEND {}";
            String principalName = this.getPrincipalName(event);
            principalName = principalName == null ? (this.request.getRemoteUser() == null ? "anonymousUser" : this.request.getRemoteUser()) : principalName;
            String requestSignature = this.request.getMethod().toLowerCase() + servletPath.replace("/", "_");
            String resultStr = "\u6743\u9650\u8ba4\u8bc1\u5931\u8d25";
            if (log.isDebugEnabled()) {
                log.info("{} [{}] [{}] {} {} {}\nheaders\n{}\nparameters\n{}\n{}", new Object[]{ipAddress, StringUtil.subString(this.getUserAgent(), 220), principalName, requestMethod, requestSignature, servletPath, StringUtil.valueOf(headers, true), StringUtil.valueOf(parameterMap, true), resultStr});
            } else {
                log.info(MSG_CODE, new Object[]{ipAddress, StringUtil.subString(this.getUserAgent(), 220), principalName, requestMethod, requestSignature, servletPath, StringUtil.valueOf(headers), StringUtil.valueOf(parameterMap), resultStr});
            }
        }
    }

    protected abstract String getPrincipalName(T var1);

    private String getUserAgent() {
        Enumeration headers = this.request.getHeaders("user-agent");
        if (headers.hasMoreElements()) {
            return (String)headers.nextElement();
        }
        return null;
    }
}

