package cn.bestwu.security.oauth2.social.provider;

import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.web.bind.annotation.ResponseStatus;

import java.util.Map;

/**
 * @author Peter Wu
 */
@com.fasterxml.jackson.databind.annotation.JsonSerialize(using = SocialExceptionJackson2Serializer.class)
@ResponseStatus(HttpStatus.BAD_REQUEST)
public class SocialException extends OAuth2Exception {
	private static final long serialVersionUID = 3767962480761186382L;

	private Integer status;

	private UserProfile userProfile;

	private Map<String, String> errors;

	public SocialException(String msg) {
		super(msg);
	}

	public SocialException(int status, String msg) {
		super(msg);
		this.status = status;
	}

	public SocialException(int status, String msg, UserProfile userProfile) {
		super(msg);
		this.status = status;
		this.userProfile = userProfile;
	}

	@Override public int getHttpErrorCode() {
		if (status == null) {
			return super.getHttpErrorCode();
		}
		return status;
	}

	public void setErrors(Map<String, String> errors) {
		this.errors = errors;
	}

	public Map<String, String> getErrors() {
		return errors;
	}

	public UserProfile getUserProfile() {
		return userProfile;
	}
}
