package cn.bestwu.security.oauth2.social.provider;

import cn.bestwu.security.oauth2.OAuth2ExceptionJackson2Serializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;

import java.io.IOException;
import java.util.Map;

public class SocialExceptionJackson2Serializer extends OAuth2ExceptionJackson2Serializer {

	private static final long serialVersionUID = 5223328500862406031L;

	@Override
	public void serialize(OAuth2Exception value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
		jgen.writeStartObject();
		jgen.writeStringField("status", String.valueOf(value.getHttpErrorCode()));
		jgen.writeStringField("message", value.getMessage());
		if (value instanceof SocialException) {
			SocialException socialException = (SocialException) value;
			cn.bestwu.security.oauth2.social.provider.UserProfile userProfile = socialException.getUserProfile();
			if (userProfile != null) {
				jgen.writeObjectField("userProfile", userProfile);
			}
			Map<String, String> errors = socialException.getErrors();
			if (errors != null) {
				jgen.writeObjectField("errors", errors);
			}
		}
		if (value.getAdditionalInformation() != null) {
			for (Map.Entry<String, String> entry : value.getAdditionalInformation().entrySet()) {
				String key = entry.getKey();
				String add = entry.getValue();
				jgen.writeStringField(key, add);
			}
		}
		jgen.writeEndObject();
	}

}