/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.security.oauth2.social.provider;

import cn.bestwu.security.oauth2.social.provider.Sex;
import cn.bestwu.security.oauth2.social.provider.SocialException;
import cn.bestwu.security.oauth2.social.provider.SocialId;
import cn.bestwu.security.oauth2.social.provider.SocialProperties;
import cn.bestwu.security.oauth2.social.provider.UserProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public abstract class SocialAdapter<T> {
    public static final String WEIXIN = "weixin";
    public static final String QQ = "qq";
    public static final String TQQ = "tqq";
    public static final String WEIBO = "weibo";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Set<String> supportProviders;
    private final RestTemplate restTemplate = this.createRestTemplate();
    private boolean autoLogon;
    private String qqAppId;
    private boolean refreshUserProfile;
    @Autowired
    private SocialProperties socialProperties;

    public SocialAdapter() {
        this.supportProviders = new HashSet<String>(4);
        this.supportProviders.add(WEIXIN);
        this.supportProviders.add(QQ);
        this.supportProviders.add(TQQ);
        this.supportProviders.add(WEIBO);
    }

    @PostConstruct
    public void init() {
        this.qqAppId = this.socialProperties.getQqAppKey();
        this.autoLogon = this.socialProperties.isAutoLogon();
        this.refreshUserProfile = this.socialProperties.isRefreshUserProfile();
    }

    public boolean isRefreshUserProfile() {
        return this.refreshUserProfile;
    }

    public boolean isAutoLogon() {
        return this.autoLogon;
    }

    public abstract SocialId<T> findByPidAndPuid(String var1, String var2);

    public abstract void saveUserProfile(T var1, UserProfile var2);

    public abstract SocialId<T> signup(UserProfile var1);

    public void afterSignup(T user) {
    }

    public abstract UserDetails loadUserDetailsByUser(T var1);

    public abstract Map<String, String> findUserProfileExtra(String var1, Map var2);

    protected RestTemplate createRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        MappingJackson2HttpMessageConverter jackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>(jackson2HttpMessageConverter.getSupportedMediaTypes());
        supportedMediaTypes.add(MediaType.TEXT_PLAIN);
        supportedMediaTypes.add(MediaType.TEXT_HTML);
        jackson2HttpMessageConverter.setSupportedMediaTypes(supportedMediaTypes);
        restTemplate.setMessageConverters(Collections.singletonList(jackson2HttpMessageConverter));
        return restTemplate;
    }

    public OAuth2Authentication createOAuth2Authentication(T user, String clientId, Set<String> scope) {
        OAuth2Request request = new OAuth2Request(null, clientId, null, true, scope, null, null, null, null);
        UserDetails userDetails = this.loadUserDetailsByUser(user);
        return new OAuth2Authentication(request, (Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)"N/A", userDetails.getAuthorities()));
    }

    public Map validateSocialTokenAndGetUserOriginalProfile(String pid, String puid, String social_token) throws SocialException {
        Map originalProfile = null;
        switch (pid) {
            case "weixin": {
                originalProfile = (Map)this.restTemplate.getForObject("https://api.weixin.qq.com/sns/userinfo?access_token={0}&openid={1}&lang=zh_CN", Map.class, new Object[]{social_token, puid});
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)social_token);
                    this.logger.debug((Object)originalProfile);
                }
                if (originalProfile.get("errcode") == null) break;
                throw new SocialException((String)originalProfile.get("errmsg"));
            }
            case "tqq": {
                originalProfile = (Map)this.restTemplate.getForObject("https://graph.qq.com/user/get_info?access_token={0}&oauth_consumer_key={1}&openid={2}&format=json", Map.class, new Object[]{social_token, this.qqAppId, puid});
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)social_token);
                    this.logger.debug((Object)originalProfile);
                }
                if (0 != (Integer)originalProfile.get("ret")) {
                    throw new SocialException((String)originalProfile.get("msg"));
                }
                originalProfile = (Map)originalProfile.get("data");
                break;
            }
            case "qq": {
                originalProfile = (Map)this.restTemplate.getForObject("https://graph.qq.com/user/get_user_info?access_token={0}&oauth_consumer_key={1}&openid={2}", Map.class, new Object[]{social_token, this.qqAppId, puid});
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)social_token);
                    this.logger.debug((Object)originalProfile);
                }
                if (0 == (Integer)originalProfile.get("ret")) break;
                throw new SocialException((String)originalProfile.get("msg"));
            }
            case "weibo": {
                originalProfile = (Map)this.restTemplate.getForObject("https://api.weibo.com/2/users/show.json?access_token={0}&uid={1}", Map.class, new Object[]{social_token, puid});
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)social_token);
                    this.logger.debug((Object)originalProfile);
                }
                if (originalProfile.get("error_code") == null) break;
                throw new SocialException((String)originalProfile.get("error"));
            }
        }
        return originalProfile;
    }

    public UserProfile originalProfile2UserProfile(String pid, String puid, Map originalUserProfile) {
        UserProfile userProfile = new UserProfile(pid, puid);
        switch (pid) {
            case "weixin": {
                userProfile.setNickname((String)originalUserProfile.get("nickname"));
                userProfile.setSex(this.getSex(originalUserProfile));
                userProfile.setImageHref((String)originalUserProfile.get("headimgurl"));
                break;
            }
            case "tqq": {
                userProfile.setNickname((String)originalUserProfile.get("nick"));
                userProfile.setSex(this.getSex(originalUserProfile));
                String head = (String)originalUserProfile.get("head");
                if (!StringUtils.hasText((String)head)) break;
                userProfile.setImageHref(head + "/100");
                break;
            }
            case "qq": {
                Sex qqsex;
                userProfile.setNickname((String)originalUserProfile.get("nickname"));
                String qqgender = (String)originalUserProfile.get("gender");
                if (qqgender == null) {
                    qqsex = Sex.UNKNOWN;
                } else {
                    switch (qqgender) {
                        case "\u7537": {
                            qqsex = Sex.MALE;
                            break;
                        }
                        case "\u5973": {
                            qqsex = Sex.FEMALE;
                            break;
                        }
                        default: {
                            qqsex = Sex.UNKNOWN;
                        }
                    }
                }
                userProfile.setSex(qqsex);
                String figureurl_qq = (String)originalUserProfile.get("figureurl_qq_2");
                if (!StringUtils.hasText((String)figureurl_qq)) {
                    figureurl_qq = (String)originalUserProfile.get("figureurl_qq_1");
                }
                userProfile.setImageHref(figureurl_qq);
                break;
            }
            case "weibo": {
                Sex sex;
                userProfile.setNickname((String)originalUserProfile.get("screen_name"));
                String gender = (String)originalUserProfile.get("gender");
                if (gender == null) {
                    sex = Sex.UNKNOWN;
                } else {
                    switch (gender) {
                        case "m": {
                            sex = Sex.MALE;
                            break;
                        }
                        case "f": {
                            sex = Sex.FEMALE;
                            break;
                        }
                        default: {
                            sex = Sex.UNKNOWN;
                        }
                    }
                }
                userProfile.setSex(sex);
                userProfile.setImageHref((String)originalUserProfile.get("avatar_large"));
            }
        }
        Map<String, String> userProfileExtra = this.findUserProfileExtra(pid, originalUserProfile);
        userProfile.setExtra(userProfileExtra);
        return userProfile;
    }

    private Sex getSex(Map originalUserProfile) {
        Sex sex;
        Integer originalSex = (Integer)originalUserProfile.get("sex");
        if (originalSex == null) {
            sex = Sex.UNKNOWN;
        } else {
            switch (originalSex) {
                case 1: {
                    sex = Sex.MALE;
                    break;
                }
                case 2: {
                    sex = Sex.FEMALE;
                    break;
                }
                default: {
                    sex = Sex.UNKNOWN;
                }
            }
        }
        return sex;
    }

    public boolean support(String grantType) {
        return this.supportProviders.contains(grantType.toLowerCase());
    }
}

