/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.security.oauth2.social.provider;

import cn.bestwu.security.oauth2.OAuth2AccessDeniedHandler;
import cn.bestwu.security.oauth2.OAuth2AuthenticationEntryPoint;
import cn.bestwu.security.oauth2.social.provider.SignupEndpoint;
import cn.bestwu.security.oauth2.social.provider.SocialAdapter;
import cn.bestwu.security.oauth2.social.provider.SocialProperties;
import cn.bestwu.security.oauth2.social.provider.SocialTokenGranter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.authserver.AuthorizationServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.config.annotation.builders.ClientDetailsServiceBuilder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.CompositeTokenGranter;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

@Configuration
@AutoConfigureOrder(value=-2147483638)
@Order(value=-2147483648)
@ConditionalOnBean(value={AuthorizationServerEndpointsConfiguration.class})
@EnableConfigurationProperties(value={AuthorizationServerProperties.class, SocialProperties.class})
public class SocialAuthorizationServerConfiguration<T>
extends AuthorizationServerConfigurerAdapter {
    private static final Log logger = LogFactory.getLog(SocialAuthorizationServerConfiguration.class);
    @Autowired
    private BaseClientDetails details;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired(required=false)
    private TokenStore tokenStore;
    @Autowired
    private AuthorizationServerProperties properties;
    @Autowired
    private SocialAdapter<T> socialAdapter;
    @Autowired
    private AuthorizationServerEndpointsConfiguration serverEndpointsConfiguration;

    @Bean
    public SignupEndpoint<T> signupEndpoint() {
        AuthorizationServerEndpointsConfigurer endpointsConfigurer = this.serverEndpointsConfiguration.getEndpointsConfigurer();
        return new SignupEndpoint<T>(this.socialAdapter, endpointsConfigurer.getTokenServices(), endpointsConfigurer.getExceptionTranslator());
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
        if (this.tokenStore != null) {
            endpoints.tokenStore(this.tokenStore);
        }
        if (this.details.getAuthorizedGrantTypes().contains("password")) {
            endpoints.authenticationManager(this.authenticationManager);
        }
        TokenGranter granter = endpoints.getTokenGranter();
        ArrayList<TokenGranter> tokenGranters = new ArrayList<TokenGranter>();
        tokenGranters.add(granter);
        tokenGranters.add(new SocialTokenGranter<T>(endpoints.getTokenServices(), endpoints.getClientDetailsService(), this.socialAdapter));
        CompositeTokenGranter tokenGranter = new CompositeTokenGranter(tokenGranters);
        endpoints.tokenGranter((TokenGranter)tokenGranter);
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        ClientDetailsServiceBuilder.ClientBuilder builder = clients.inMemory().withClient(this.details.getClientId());
        builder.secret(this.details.getClientSecret()).resourceIds(this.details.getResourceIds().toArray(new String[0])).authorizedGrantTypes(this.details.getAuthorizedGrantTypes().toArray(new String[0])).authorities(AuthorityUtils.authorityListToSet((Collection)this.details.getAuthorities()).toArray(new String[0])).scopes(this.details.getScope().toArray(new String[0]));
        if (this.details.getAutoApproveScopes() != null) {
            builder.autoApprove(this.details.getAutoApproveScopes().toArray(new String[0]));
        }
        if (this.details.getAccessTokenValiditySeconds() != null) {
            builder.accessTokenValiditySeconds(this.details.getAccessTokenValiditySeconds().intValue());
        }
        if (this.details.getRefreshTokenValiditySeconds() != null) {
            builder.refreshTokenValiditySeconds(this.details.getRefreshTokenValiditySeconds().intValue());
        }
        if (this.details.getRegisteredRedirectUri() != null) {
            builder.redirectUris(this.details.getRegisteredRedirectUri().toArray(new String[0]));
        }
    }

    public void configure(AuthorizationServerSecurityConfigurer security) throws Exception {
        if (this.properties.getCheckTokenAccess() != null) {
            security.checkTokenAccess(this.properties.getCheckTokenAccess());
        }
        if (this.properties.getTokenKeyAccess() != null) {
            security.tokenKeyAccess(this.properties.getTokenKeyAccess());
        }
        if (this.properties.getRealm() != null) {
            security.realm(this.properties.getRealm());
        }
        security.accessDeniedHandler((AccessDeniedHandler)new OAuth2AccessDeniedHandler());
        security.authenticationEntryPoint((AuthenticationEntryPoint)new OAuth2AuthenticationEntryPoint());
    }

    @Configuration
    @ConditionalOnMissingBean(value={BaseClientDetails.class})
    protected static class BaseClientDetailsConfiguration {
        @Autowired
        private OAuth2ClientProperties client;

        protected BaseClientDetailsConfiguration() {
        }

        @Bean
        @ConfigurationProperties(value="security.oauth2.client")
        public BaseClientDetails oauth2ClientDetails() {
            BaseClientDetails details = new BaseClientDetails();
            if (this.client.getClientId() == null) {
                this.client.setClientId(UUID.randomUUID().toString());
            }
            details.setClientId(this.client.getClientId());
            details.setClientSecret(this.client.getClientSecret());
            details.setAuthorizedGrantTypes(Arrays.asList("authorization_code", "password", "client_credentials", "implicit", "refresh_token", "weixin", "weibo", "qq"));
            details.setAuthorities((Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"ROLE_USER"));
            details.setRegisteredRedirectUri(Collections.emptySet());
            return details;
        }
    }

    @Configuration
    protected static class ClientDetailsLogger {
        @Autowired
        private OAuth2ClientProperties credentials;

        protected ClientDetailsLogger() {
        }

        @PostConstruct
        public void init() {
            String prefix = "security.oauth2.client";
            boolean defaultSecret = this.credentials.isDefaultSecret();
            logger.info((Object)String.format("Initialized OAuth2 Client\n\n%s.clientId = %s\n%s.secret = %s\n\n", prefix, this.credentials.getClientId(), prefix, defaultSecret ? this.credentials.getClientSecret() : "****"));
        }
    }
}

