/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.security.oauth2.social.provider;

import cn.bestwu.security.oauth2.social.provider.SocialExceptionJackson2Serializer;
import cn.bestwu.security.oauth2.social.provider.UserProfile;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.web.bind.annotation.ResponseStatus;

@JsonSerialize(using=SocialExceptionJackson2Serializer.class)
@ResponseStatus(value=HttpStatus.BAD_REQUEST)
public class SocialException
extends OAuth2Exception {
    private static final long serialVersionUID = 3767962480761186382L;
    private Integer status;
    private UserProfile userProfile;
    private Map<String, String> errors;

    public SocialException(String msg) {
        super(msg);
    }

    public SocialException(int status, String msg) {
        super(msg);
        this.status = status;
    }

    public SocialException(int status, String msg, UserProfile userProfile) {
        super(msg);
        this.status = status;
        this.userProfile = userProfile;
    }

    public int getHttpErrorCode() {
        if (this.status == null) {
            return super.getHttpErrorCode();
        }
        return this.status;
    }

    public void setErrors(Map<String, String> errors) {
        this.errors = errors;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }
}

