/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.security.oauth2.social.provider;

import cn.bestwu.security.oauth2.OAuth2ExceptionJackson2Serializer;
import cn.bestwu.security.oauth2.social.provider.SocialException;
import cn.bestwu.security.oauth2.social.provider.UserProfile;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;

public class SocialExceptionJackson2Serializer
extends OAuth2ExceptionJackson2Serializer {
    private static final long serialVersionUID = 5223328500862406031L;

    public void serialize(OAuth2Exception value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("status", String.valueOf(value.getHttpErrorCode()));
        jgen.writeStringField("message", value.getMessage());
        if (value instanceof SocialException) {
            Map<String, String> errors;
            SocialException socialException = (SocialException)value;
            UserProfile userProfile = socialException.getUserProfile();
            if (userProfile != null) {
                jgen.writeObjectField("userProfile", (Object)userProfile);
            }
            if ((errors = socialException.getErrors()) != null) {
                jgen.writeObjectField("errors", errors);
            }
        }
        if (value.getAdditionalInformation() != null) {
            for (Map.Entry entry : value.getAdditionalInformation().entrySet()) {
                String key = (String)entry.getKey();
                String add = (String)entry.getValue();
                jgen.writeStringField(key, add);
            }
        }
        jgen.writeEndObject();
    }
}

