/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.security.oauth2.social.provider;

import cn.bestwu.security.oauth2.social.provider.SocialAdapter;
import cn.bestwu.security.oauth2.social.provider.SocialException;
import cn.bestwu.security.oauth2.social.provider.SocialId;
import cn.bestwu.security.oauth2.social.provider.UserProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.util.StringUtils;

public class SocialTokenGranter<T>
implements TokenGranter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final AuthorizationServerTokenServices tokenServices;
    private final ClientDetailsService clientDetailsService;
    private final SocialAdapter<T> socialAdapter;

    public SocialTokenGranter(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService, SocialAdapter<T> socialAdapter) {
        this.clientDetailsService = clientDetailsService;
        this.tokenServices = tokenServices;
        this.socialAdapter = socialAdapter;
    }

    public OAuth2AccessToken grant(String grantType, TokenRequest tokenRequest) {
        if (!this.socialAdapter.support(grantType = grantType.toLowerCase())) {
            return null;
        }
        String clientId = tokenRequest.getClientId();
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
        this.validateGrantType(grantType, client);
        this.logger.debug((Object)("Getting access token for: " + clientId));
        return this.tokenServices.createAccessToken(this.getOAuth2Authentication(grantType, tokenRequest));
    }

    protected void validateGrantType(String grantType, ClientDetails clientDetails) {
        Set authorizedGrantTypes = clientDetails.getAuthorizedGrantTypes();
        if (authorizedGrantTypes != null && !authorizedGrantTypes.isEmpty() && !authorizedGrantTypes.contains(grantType)) {
            throw new InvalidClientException("Unauthorized grant type: " + grantType);
        }
    }

    protected OAuth2Authentication getOAuth2Authentication(String pid, TokenRequest tokenRequest) {
        Map requestParameters = tokenRequest.getRequestParameters();
        String puid = (String)requestParameters.get("puid");
        String social_token = (String)requestParameters.get("social_token");
        if (!StringUtils.hasText((String)puid)) {
            throw new SocialException(HttpStatus.UNPROCESSABLE_ENTITY.value(), "puid must be supplied.");
        }
        if (!StringUtils.hasText((String)social_token)) {
            throw new SocialException(HttpStatus.UNPROCESSABLE_ENTITY.value(), "social_token must be supplied.");
        }
        Map originalProfile = this.socialAdapter.validateSocialTokenAndGetUserOriginalProfile(pid, puid, social_token);
        SocialId<T> socialId = this.socialAdapter.findByPidAndPuid(pid, puid);
        if (socialId == null) {
            UserProfile userProfile = this.socialAdapter.originalProfile2UserProfile(pid, puid, originalProfile);
            if (this.socialAdapter.isAutoLogon()) {
                try {
                    socialId = this.socialAdapter.signup(userProfile);
                    T user = socialId.getUser();
                    OAuth2Authentication authentication = this.socialAdapter.createOAuth2Authentication(user, tokenRequest.getClientId(), tokenRequest.getScope());
                    SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                    this.socialAdapter.afterSignup(user);
                    return authentication;
                }
                catch (ConstraintViolationException e) {
                    Set constraintViolations = e.getConstraintViolations();
                    HashMap<String, String> errors = new HashMap<String, String>();
                    constraintViolations.forEach(constraintViolation -> errors.put(constraintViolation.getPropertyPath().toString(), constraintViolation.getMessage()));
                    SocialException socialException = new SocialException(HttpStatus.UNPROCESSABLE_ENTITY.value(), (String)errors.values().iterator().next(), userProfile);
                    socialException.setErrors(errors);
                    throw socialException;
                }
                catch (DataIntegrityViolationException e) {
                    String message;
                    String specificCauseMessage = e.getMostSpecificCause().getMessage();
                    String duplicateRegex = "^Duplicate entry '(.*?)'.*";
                    String constraintSubfix = "Cannot delete or update a parent row";
                    int httpStatusCode = 500;
                    if (specificCauseMessage.matches(duplicateRegex)) {
                        httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                        message = specificCauseMessage.replaceAll(duplicateRegex, "$1") + "\u5df2\u7ecf\u5b58\u5728";
                        if (!StringUtils.hasText((String)message)) {
                            message = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25";
                        }
                    } else if (specificCauseMessage.startsWith(constraintSubfix)) {
                        httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                        message = "\u4e0d\u80fd\u5220\u9664\u6216\u66f4\u65b0\u5173\u8054\u5b9e\u4f53\uff0c\u5176\u4ed6\u7684\u8d44\u6e90\u5f15\u7528\u4e86\u6b64\u5b9e\u4f53";
                        if (!StringUtils.hasText((String)message)) {
                            message = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25";
                        }
                    } else {
                        message = e.getRootCause().getMessage();
                    }
                    throw new SocialException(httpStatusCode, message, userProfile);
                }
            }
            throw new SocialException(HttpStatus.NOT_FOUND.value(), "\u8d26\u53f7\u672a\u521d\u59cb\u5316", userProfile);
        }
        if (this.socialAdapter.isRefreshUserProfile()) {
            try {
                UserProfile userProfile = this.socialAdapter.originalProfile2UserProfile(pid, puid, originalProfile);
                this.socialAdapter.saveUserProfile(socialId.getUser(), userProfile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.socialAdapter.createOAuth2Authentication(socialId.getUser(), tokenRequest.getClientId(), tokenRequest.getScope());
    }
}

