package cn.bestwu.security.oauth2.social.provider;

import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.web.bind.annotation.ResponseStatus;

import java.util.Map;

/**
 * 社交账号登录/注册异常
 *
 * @author Peter Wu
 */
@com.fasterxml.jackson.databind.annotation.JsonSerialize(using = SocialExceptionJackson2Serializer.class)
@ResponseStatus(HttpStatus.BAD_REQUEST)
public class SocialException extends OAuth2Exception {
	private static final long serialVersionUID = 3767962480761186382L;

	/**
	 * 状态码
	 */
	private Integer status;
	/**
	 * 用户资料
	 */
	private UserProfile userProfile;
	/**
	 * 错误详情
	 */
	private Map<String, String> errors;

	public SocialException(String msg) {
		super(msg);
	}

	public SocialException(int status, String msg) {
		super(msg);
		this.status = status;
	}

	public SocialException(int status, String msg, UserProfile userProfile) {
		super(msg);
		this.status = status;
		this.userProfile = userProfile;
	}

	/**
	 * @return 状态码
	 */
	@Override public int getHttpErrorCode() {
		if (status == null) {
			return super.getHttpErrorCode();
		}
		return status;
	}

	public void setErrors(Map<String, String> errors) {
		this.errors = errors;
	}

	/**
	 * @return 错误详情
	 */
	public Map<String, String> getErrors() {
		return errors;
	}

	/**
	 * @return 用户资料
	 */
	public UserProfile getUserProfile() {
		return userProfile;
	}
}
