package cn.bestwu.security.oauth2.social.provider;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 社交账号相关配置属性
 *
 * @author Peter Wu
 */
@ConfigurationProperties("social.oauth2")
public class SocialProperties {

	/**
	 * QQ appkey
	 */
	private String qqAppKey;
	/**
	 * 是否自动注册
	 */
	private boolean autoLogon = true;
	/**
	 * 是否每次登录刷新用户资料
	 */
	private boolean refreshUserProfile = false;

	public String getQqAppKey() {
		return qqAppKey;
	}

	public void setQqAppKey(String qqAppKey) {
		this.qqAppKey = qqAppKey;
	}

	public boolean isAutoLogon() {
		return autoLogon;
	}

	public void setAutoLogon(boolean autoLogon) {
		this.autoLogon = autoLogon;
	}

	public boolean isRefreshUserProfile() {
		return refreshUserProfile;
	}

	public void setRefreshUserProfile(boolean refreshUserProfile) {
		this.refreshUserProfile = refreshUserProfile;
	}
}
