package cn.bestwu.security.oauth2.social.provider;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.web.multipart.MultipartFile;

import java.io.Serializable;
import java.util.Map;

/**
 * 用户资料
 *
 * @author Peter Wu
 */
public class UserProfile implements Serializable {

	private static final long serialVersionUID = -8343127525286798341L;
	/**
	 * providerId
	 */
	private String pid;
	/**
	 * providerUserId
	 */
	private String puid;

	/**
	 * 昵称
	 */
	private String nickname;
	/**
	 * 性别
	 */
	private Sex sex;
	/**
	 * 头像地址
	 */
	private String imageHref;

	/**
	 * 注册自定义头像上传文件
	 */
	@JsonIgnore
	private transient MultipartFile file;

	/**
	 * 扩展信息
	 */
	private Map<String, String> extra;
	//--------------------------------------------

	public UserProfile() {
	}

	public UserProfile(String pid, String puid) {
		this.pid = pid;
		this.puid = puid;
	}

	//--------------------------------------------

	/**
	 * @return 社交账号类型
	 */
	public String getPid() {
		return pid;
	}

	public void setPid(String pid) {
		this.pid = pid;
	}

	/**
	 * @return 社交账号用户ID
	 */
	public String getPuid() {
		return puid;
	}

	public void setPuid(String puid) {
		this.puid = puid;
	}

	/**
	 * @return 昵称
	 */
	public String getNickname() {
		return nickname;
	}

	public void setNickname(String nickname) {
		this.nickname = nickname;
	}

	/**
	 * @return 性别
	 */
	public Sex getSex() {
		return sex;
	}

	public void setSex(Sex sex) {
		this.sex = sex;
	}

	/**
	 * @return 头像url
	 */
	public String getImageHref() {
		return imageHref;
	}

	public void setImageHref(String imageHref) {
		this.imageHref = imageHref;
	}

	/**
	 * @return 上传头像
	 */
	public MultipartFile getFile() {
		return file;
	}

	public void setFile(MultipartFile file) {
		this.file = file;
	}

	/**
	 * @return 扩展资料
	 */
	@JsonAnyGetter
	public Map<String, String> getExtra() {
		return extra;
	}

	public void setExtra(Map<String, String> extra) {
		this.extra = extra;
	}

	//--------------------------------------------
	@JsonIgnore
	public boolean isWeixin() {
		return SocialAdapter.WEIXIN.equals(pid);
	}

	@JsonIgnore
	public boolean isWeibo() {
		return SocialAdapter.WEIBO.equals(pid);
	}

	@JsonIgnore
	public boolean isQq() {
		return SocialAdapter.QQ.equals(pid);
	}

	@JsonIgnore
	public boolean isTqq() {
		return SocialAdapter.TQQ.equals(pid);
	}

}
