/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.data;

import cn.bestwu.simpleframework.web.ErrorAttributes;
import cn.bestwu.simpleframework.web.IErrorHandler;
import cn.bestwu.simpleframework.web.RespEntity;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.util.StringUtils;

public class DataErrorHandler
implements IErrorHandler {
    @Autowired
    private MessageSource messageSource;
    @Autowired(required=false)
    private HttpServletRequest request;

    public void handlerException(Throwable error, RespEntity respEntity) {
        String message = null;
        Map errors = respEntity.getErrors();
        if (error instanceof EmptyResultDataAccessException) {
            respEntity.setHttpStatus(HttpStatus.NOT_FOUND);
            if (!StringUtils.hasText(message)) {
                message = "resource.not.found";
            }
        } else if (error instanceof TransactionSystemException) {
            if ((error = ((TransactionSystemException)error).getRootCause()) instanceof ConstraintViolationException) {
                respEntity.setHttpStatus(HttpStatus.UNPROCESSABLE_ENTITY);
                ConstraintViolationException er = (ConstraintViolationException)error;
                Set constraintViolations = er.getConstraintViolations();
                for (ConstraintViolation constraintViolation : constraintViolations) {
                    String property = ErrorAttributes.getProperty((ConstraintViolation)constraintViolation);
                    errors.put(property, this.getText(this.messageSource, this.request, property, new Object[0]) + ":" + constraintViolation.getMessage());
                }
                message = (String)errors.values().iterator().next();
                if (!StringUtils.hasText((String)message)) {
                    message = "data.valid.failed";
                }
            }
        } else if (error instanceof DataIntegrityViolationException) {
            String specificCauseMessage = ((DataIntegrityViolationException)error).getMostSpecificCause().getMessage();
            String duplicateRegex = "^Duplicate entry '(.*?)'.*";
            String dataTooLongRegex = "^Data truncation: Data too long for column '(.*?)'.*";
            String constraintSubfix = "Cannot delete or update a parent row";
            if (specificCauseMessage.matches(duplicateRegex)) {
                respEntity.setHttpStatus(HttpStatus.UNPROCESSABLE_ENTITY);
                String columnName = this.getText(this.messageSource, this.request, specificCauseMessage.replaceAll(duplicateRegex, "$1"), new Object[0]);
                message = this.getText(this.messageSource, this.request, "duplicate.entry", new Object[]{columnName});
                if (!StringUtils.hasText((String)message)) {
                    message = "data.valid.failed";
                }
            } else if (specificCauseMessage.matches(dataTooLongRegex)) {
                respEntity.setHttpStatus(HttpStatus.UNPROCESSABLE_ENTITY);
                String columnName = this.getText(this.messageSource, this.request, specificCauseMessage.replaceAll(dataTooLongRegex, "$1"), new Object[0]);
                message = this.getText(this.messageSource, this.request, "data.too.long", new Object[]{columnName});
                if (!StringUtils.hasText((String)message)) {
                    message = "data.valid.failed";
                }
            } else if (specificCauseMessage.startsWith(constraintSubfix)) {
                respEntity.setHttpStatus(HttpStatus.UNPROCESSABLE_ENTITY);
                message = "cannot.delete.update.parent";
                if (!StringUtils.hasText((String)message)) {
                    message = "data.valid.failed";
                }
            } else {
                message = ((DataIntegrityViolationException)error).getRootCause().getMessage();
            }
        } else if (error instanceof CannotCreateTransactionException) {
            respEntity.setHttpStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            message = "datasource.request.timeout";
        }
        if (StringUtils.hasText((String)message)) {
            respEntity.setMessage(message);
        }
    }
}

