/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.data;

import cn.bestwu.simpleframework.data.RepositoryMetadata;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class Repositories
implements Iterable<Class<?>> {
    private final Logger log = LoggerFactory.getLogger(Repositories.class);
    private final Map<Class<?>, RepositoryMetadata> repositoryMetadatas = new HashMap();

    public Repositories(List<MapperFactoryBean> mapperFactoryBeans, Set<Class<?>> allSubClasses) {
        if (!CollectionUtils.isEmpty(mapperFactoryBeans)) {
            this.populateRepositoryMetadata(mapperFactoryBeans, allSubClasses);
        }
    }

    private void populateRepositoryMetadata(List<MapperFactoryBean> mapperFactoryBeans, Set<Class<?>> allSubClasses) {
        HashMap<Class, Class> queryDsls = new HashMap<Class, Class>();
        for (Class<?> queryDslType : allSubClasses) {
            Class modelClass = (Class)((ParameterizedType)queryDslType.getGenericSuperclass()).getActualTypeArguments()[1];
            if (this.log.isDebugEnabled()) {
                this.log.debug("Detected queryDsl:{}=>{}", (Object)modelClass, queryDslType);
            }
            queryDsls.put(modelClass, queryDslType);
        }
        try {
            for (MapperFactoryBean mapperFactoryBean : mapperFactoryBeans) {
                if (!BaseMapper.class.isAssignableFrom(mapperFactoryBean.getMapperInterface())) continue;
                RepositoryMetadata repositoryMetadata = new RepositoryMetadata((BaseMapper)mapperFactoryBean.getObject(), mapperFactoryBean.getMapperInterface(), queryDsls);
                this.putRepositoryMetadata(repositoryMetadata);
            }
        }
        catch (Exception e) {
            this.log.error("populateRepositoryMetadata fail", (Throwable)e);
        }
    }

    public void putRepositoryMetadata(RepositoryMetadata repositoryMetadata) {
        this.repositoryMetadatas.put(repositoryMetadata.getModelClass(), repositoryMetadata);
    }

    public boolean hasRepositoryFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"Domain type must not be null!");
        return this.repositoryMetadatas.containsKey(domainClass);
    }

    public RepositoryMetadata getRepositoryMetadataFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"Domain type must not be null!");
        return this.repositoryMetadatas.get(domainClass);
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return this.repositoryMetadatas.keySet().iterator();
    }
}

