/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.data.resolver;

import cn.bestwu.lang.util.StringUtil;
import cn.bestwu.simpleframework.data.Repositories;
import cn.bestwu.simpleframework.data.RepositoryMetadata;
import cn.bestwu.simpleframework.exception.ResourceNotFoundException;
import cn.bestwu.simpleframework.web.resolver.ModifyModel;
import java.beans.Introspector;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;

public class ModifyModelMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final Logger log = LoggerFactory.getLogger(ModifyModelMethodArgumentResolver.class);
    private final Repositories repositories;

    public ModifyModelMethodArgumentResolver(Repositories repositories) {
        this.repositories = repositories;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(ModifyModel.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        return this.resolveModel(parameter, mavContainer, webRequest, binderFactory);
    }

    protected Object resolveModel(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Object content = this.getObjectForUpdate(parameter, webRequest, binderFactory);
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u8bf7\u6c42\u539f\u5b9e\u4f53\uff1a" + StringUtil.valueOf((Object)content));
        }
        Object o = this.readObject(parameter, content, mavContainer, webRequest, binderFactory);
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u8bf7\u6c42\u5b9e\u4f53\u4fee\u6539\u540e\uff1a" + StringUtil.valueOf((Object)o));
        }
        return o;
    }

    private String getId(WebDataBinder binder, String idParameterName, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        String[] arg = this.resolveName(idParameterName, webRequest);
        if (arg == null) {
            arg = webRequest.getParameterValues(idParameterName);
        }
        if (binderFactory != null && arg != null) {
            return (String)binder.convertIfNecessary((Object)arg, String.class);
        }
        return null;
    }

    protected Object resolveName(String name, NativeWebRequest request) {
        Map uriTemplateVars = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
        return uriTemplateVars != null ? uriTemplateVars.get(name) : null;
    }

    private Object getObjectForUpdate(MethodParameter parameter, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        RepositoryMetadata repositoryMetadata;
        Object modelForUpdate;
        ModifyModel modifyModel = (ModifyModel)parameter.getParameterAnnotation(ModifyModel.class);
        String idParameterName = modifyModel.idParameter();
        WebDataBinder binder = binderFactory.createBinder(webRequest, null, idParameterName);
        String id = this.getId(binder, idParameterName, webRequest, binderFactory);
        if (id == null) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Class parameterType = parameter.getParameterType();
        Class modelType = modifyModel.value();
        if (Object.class.equals((Object)modelType)) {
            modelType = parameterType;
        }
        if ((modelForUpdate = (repositoryMetadata = this.repositories.getRepositoryMetadataFor(modelType)).invokeFindOne((Serializable)binder.convertIfNecessary((Object)id, repositoryMetadata.getIdType()))) == null) {
            throw new ResourceNotFoundException();
        }
        Object oldModel = modelType.newInstance();
        BeanUtils.copyProperties((Object)modelForUpdate, oldModel);
        webRequest.setAttribute("OLD_MODEL", oldModel, 0);
        if (parameterType.equals(modelType)) {
            return modelForUpdate;
        }
        Object paramForUpdate = parameterType.newInstance();
        BeanUtils.copyProperties((Object)modelForUpdate, paramForUpdate);
        return paramForUpdate;
    }

    private Object readObject(MethodParameter parameter, Object modelObject, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Class<?> modelType = modelObject.getClass();
        String name = Introspector.decapitalize(modelType.getSimpleName());
        WebDataBinder binder = binderFactory.createBinder(webRequest, modelObject, name);
        if (binder.getTarget() != null) {
            this.bindRequestParameters(binder, webRequest);
            this.validateIfApplicable(binder, parameter);
            if (binder.getBindingResult().hasErrors()) {
                throw new BindException(binder.getBindingResult());
            }
        }
        Map bindingResultModel = binder.getBindingResult().getModel();
        mavContainer.removeAttributes(bindingResultModel);
        mavContainer.addAllAttributes(bindingResultModel);
        return binder.convertIfNecessary(binder.getTarget(), modelType);
    }

    protected void validateIfApplicable(WebDataBinder binder, MethodParameter methodParam) {
        Annotation[] annotations;
        for (Annotation ann : annotations = methodParam.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validatedAnn = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validatedAnn == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnn != null ? validatedAnn.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] validationHints = objectArray;
            binder.validate(validationHints);
            break;
        }
    }

    protected void bindRequestParameters(WebDataBinder binder, NativeWebRequest request) {
        ServletRequest servletRequest = (ServletRequest)request.getNativeRequest(ServletRequest.class);
        ServletRequestDataBinder servletBinder = (ServletRequestDataBinder)binder;
        servletBinder.bind(servletRequest);
    }

    protected final Object createAttribute(String attributeName, Class<?> modelClass, WebDataBinderFactory binderFactory, NativeWebRequest request) throws Exception {
        Object attribute;
        String value = this.getRequestValueForAttribute(attributeName, request);
        if (value != null && (attribute = this.createAttributeFromRequestValue(value, attributeName, modelClass, binderFactory, request)) != null) {
            return attribute;
        }
        return BeanUtils.instantiateClass(modelClass);
    }

    protected String getRequestValueForAttribute(String attributeName, NativeWebRequest request) {
        if (StringUtils.hasText((String)request.getParameter(attributeName))) {
            return request.getParameter(attributeName);
        }
        return null;
    }

    protected Object createAttributeFromRequestValue(String sourceValue, String attributeName, Class<?> modelClass, WebDataBinderFactory binderFactory, NativeWebRequest request) throws Exception {
        TypeDescriptor target;
        TypeDescriptor source;
        WebDataBinder binder = binderFactory.createBinder(request, null, attributeName);
        ConversionService conversionService = binder.getConversionService();
        if (conversionService != null && conversionService.canConvert(source = TypeDescriptor.valueOf(String.class), target = TypeDescriptor.valueOf(modelClass))) {
            return binder.convertIfNecessary((Object)sourceValue, modelClass);
        }
        return null;
    }
}

