/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.data;

import cn.bestwu.simpleframework.data.IBaseService;
import cn.bestwu.simpleframework.data.PaginationList;
import cn.bestwu.simpleframework.data.Repositories;
import cn.bestwu.simpleframework.data.RepositoryMetadata;
import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<M, T>
implements IBaseService<T> {
    @Autowired
    private Repositories repositories;
    private Map<String, String> cachedFieldsMap;
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void init() {
        RepositoryMetadata repositoryMetadata = this.repositories.getRepositoryMetadataFor(this.currentModelClass());
        this.cachedFieldsMap = repositoryMetadata == null ? new HashMap() : repositoryMetadata.getCachedFieldsMap();
    }

    @Override
    public boolean deleteByPropertyMap(Map<String, Object> propertyMap) {
        return super.deleteByMap(this.convert2ColumnMap(propertyMap));
    }

    @Override
    @NotNull
    public Map<String, Object> convert2ColumnMap(Map<String, Object> propertyMap) {
        HashMap<String, Object> columnMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
            columnMap.put(this.cachedFieldsMap.get(entry.getKey()), entry.getValue());
        }
        return columnMap;
    }

    @Override
    public List<T> selectByPropertyMap(Map<String, Object> propertyMap) {
        return super.selectByMap(this.convert2ColumnMap(propertyMap));
    }

    protected String like(String keyword) {
        return org.springframework.util.StringUtils.hasText((String)keyword) ? "%" + keyword + "%" : null;
    }

    protected String sort(String sort) {
        return "asc".equalsIgnoreCase(sort) ? "asc" : "desc";
    }

    @Override
    public String getColumnName(String propertyName) {
        return this.cachedFieldsMap.get(propertyName);
    }

    public boolean insertOrUpdate(T entity) {
        if (null != entity) {
            Class<?> cls = entity.getClass();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
            if (tableInfo == null) {
                tableInfo = TableInfoHelper.getTableInfo(cls.getSuperclass());
            }
            return this.insertOrUpdate(entity, cls, tableInfo);
        }
        return false;
    }

    private boolean insertOrUpdate(T entity, Class<?> cls, TableInfo tableInfo) {
        if (null != tableInfo && StringUtils.isNotEmpty((CharSequence)tableInfo.getKeyProperty())) {
            Object idVal = ReflectionKit.getMethodValue(cls, entity, (String)tableInfo.getKeyProperty());
            if (StringUtils.checkValNull((Object)idVal)) {
                return this.insert(entity);
            }
            return this.updateById(entity) || this.insert(entity);
        }
        throw new MybatisPlusException("Error:  Can not execute. Could not find @TableId.");
    }

    @Override
    public boolean insertOrUpdate(T entity, Class<?> cls) {
        if (null != entity) {
            TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
            return this.insertOrUpdate(entity, cls, tableInfo);
        }
        return false;
    }

    public static <T> Page<T> page(List<T> list) {
        Page page = new Page();
        page.setRecords(list);
        if (list instanceof PaginationList) {
            Pagination pagination = ((PaginationList)list).getPagination();
            page.setCurrent(pagination.getCurrent());
            page.setSize(pagination.getSize());
            page.setTotal(pagination.getTotal());
        } else if (list instanceof Collection) {
            page.setCurrent(1);
            page.setSize(list.size());
            page.setTotal((long)list.size());
        }
        return page;
    }
}

