/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.data.interceptor;

import cn.bestwu.simpleframework.data.Pageable;
import com.baomidou.mybatisplus.plugins.pagination.PageHelper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class PageableHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final String DEFAULT_PAGE_PARAMETER = "page";
    private static final String DEFAULT_SIZE_PARAMETER = "size";
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final int DEFAULT_MAX_PAGE_SIZE = 2000;
    private String pageParameterName = "page";
    private String sizeParameterName = "size";
    private int maxPageSize = 2000;
    private boolean oneIndexedParameters = false;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (this.supportsHandler(handler)) {
            String pageString = request.getParameter(this.pageParameterName);
            String pageSizeString = request.getParameter(this.sizeParameterName);
            int page = this.parseAndApplyBoundaries(pageString, Integer.MAX_VALUE, true);
            int pageSize = StringUtils.hasText((String)pageSizeString) ? this.parseAndApplyBoundaries(pageSizeString, this.maxPageSize, false) : 20;
            PageHelper.startPage((int)page, (int)pageSize);
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.supportsHandler(handler)) {
            PageHelper.remove();
        }
    }

    private boolean supportsHandler(Object handler) {
        return handler instanceof HandlerMethod && ((HandlerMethod)handler).hasMethodAnnotation(Pageable.class);
    }

    private int parseAndApplyBoundaries(String parameter, int upper, boolean shiftIndex) {
        try {
            int parsed = Integer.parseInt(parameter) - (this.oneIndexedParameters && shiftIndex ? 1 : 0);
            return parsed < 1 ? 1 : (parsed > upper ? upper : parsed);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public void setPageParameterName(String pageParameterName) {
        this.pageParameterName = pageParameterName;
    }

    public void setSizeParameterName(String sizeParameterName) {
        this.sizeParameterName = sizeParameterName;
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public void setOneIndexedParameters(boolean oneIndexedParameters) {
        this.oneIndexedParameters = oneIndexedParameters;
    }
}

