package cn.bestwu.simpleframework.support.excel;

import org.apache.poi.ss.usermodel.Row;

/**
 * @author Peter Wu
 * @since 1.0.0
 */
public interface CellValueConverter {

  /**
   * @param fieldValue 实体属性
   * @param description {@link ExcelField} 注释的字段或方法
   * @param obj 实体对象
   * @return 单元格值
   */
  default String toCell(Object fieldValue, ExcelFieldDescription description, Object obj) {
    return String.valueOf(fieldValue);
  }

  /**
   * @param cellValue 单元格值
   * @param description {@link ExcelField} 注释的字段或方法
   * @param obj 实体对象
   * @param row excel 行数据
   * @return 实体属性
   */
  default Object fromCell(String cellValue, ExcelFieldDescription description, Object obj,
      Row row) {
    return cellValue;
  }

}
