package cn.bestwu.simpleframework.support.excel.converter;

import cn.bestwu.simpleframework.support.excel.CellValueConverter;
import cn.bestwu.simpleframework.support.excel.ExcelField;
import cn.bestwu.simpleframework.support.excel.ExcelFieldDescription;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.StringUtils;

public abstract class AbstractCodeConverter implements CellValueConverter {

  @NotNull
  protected String getCodeType(ExcelFieldDescription description) {
    AccessibleObject accessibleObject = description.getAccessibleObject();
    String codeType = description.getExcelField().converterUsing();
    if (!StringUtils.hasText(codeType)) {
      if (accessibleObject instanceof Field) {
        codeType = ((Field) accessibleObject).getName();
      } else if (accessibleObject instanceof Method) {
        codeType = ((Method) accessibleObject).getName();
        if (codeType.startsWith("get")) {
          codeType = StringUtils.uncapitalize(codeType.substring(3));
        }
      } else {
        try {
          throw new RuntimeException(
              "请配置@" + ExcelField.class.getName() + "的" + ExcelField.class.getMethod("converterUsing").getName()
                  + "属性");
        } catch (NoSuchMethodException ignored) {
        }
      }
    }
    return codeType;
  }

}