package cn.bestwu.simpleframework.support.excel.converter;

import cn.bestwu.simpleframework.support.LocalDateTimeHelper;
import cn.bestwu.simpleframework.support.excel.ExcelFieldDescription;
import java.util.Date;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;

public class DateConverter extends AbstractDateConverter {

  private static final DateConverter instance = new DateConverter();

  private DateConverter() {
  }

  public static DateConverter newInstance() {
    return instance;
  }

  @Override
  public String toCell(Object fieldValue, ExcelFieldDescription description, Object obj) {
    return LocalDateTimeHelper.of((Date) fieldValue).format(getDateTimeFormatter(description));
  }

  @Override
  public Object fromCell(String cellValue, ExcelFieldDescription description, Object obj,
      Row row) {
    return LocalDateTimeHelper.of(DateUtil.getJavaDate(Double.valueOf(cellValue))).toDate();
  }
}