package cn.bestwu.simpleframework.support.excel.converter;

import cn.bestwu.simpleframework.support.LocalDateTimeHelper;
import cn.bestwu.simpleframework.support.excel.ExcelFieldDescription;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;

public class MillisConverter extends AbstractDateConverter {

  private static final MillisConverter instance = new MillisConverter();

  private MillisConverter() {
  }

  public static MillisConverter newInstance() {
    return instance;
  }

  @Override
  public String toCell(Object fieldValue, ExcelFieldDescription description, Object obj) {
    return LocalDateTimeHelper.of((Long) fieldValue).format(getDateTimeFormatter(description));
  }

  @Override
  public Object fromCell(String cellValue, ExcelFieldDescription description, Object obj,
      Row row) {
    return LocalDateTimeHelper.of(DateUtil.getJavaDate(Double.valueOf(cellValue))).toMillis();
  }
}