package cn.bestwu.simpleframework.web.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;

public class CustomNullBeanSerializerModifier extends BeanSerializerModifier {

  @Override
  public List<BeanPropertyWriter> changeProperties(SerializationConfig config,
      BeanDescription beanDesc,
      List<BeanPropertyWriter> beanProperties) {
    for (BeanPropertyWriter writer : beanProperties) {
      Class<?> rawClass = writer.getType().getRawClass();
      if (!writer.hasNullSerializer()) {
        writer.assignNullSerializer(new StdSerializer<Object>(Object.class) {
          private static final long serialVersionUID = -3272802392550287442L;

          @Override
          public void serialize(Object value, JsonGenerator gen, SerializerProvider provider)
              throws IOException {
            NullAsEmptySerializer.serializeNull(gen, rawClass, value);
          }
        });
      }
    }
    return beanProperties;
  }

}