package cn.bestwu.simpleframework.web.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import org.springframework.util.StringUtils;

/**
 * JSON 序列化电话号码自动隐藏
 *
 * @author Peter Wu
 */
@JacksonStdImpl
public class HideTelSerializer extends StdScalarSerializer<String> {

  private static final long serialVersionUID = 1L;

  public HideTelSerializer() {
    super(String.class, false);
  }

  public static String convert(String value) {
    if (StringUtils.hasText(value) && value.length() == 11) {
      char[] chars = value.toCharArray();
      for (int i = 0; i < chars.length; i++) {
        if (i > 2 && i < 7) {
          chars[i] = '*';
        }
        return new String(chars);
      }
    }
    return value;
  }

  @Override
  public void serialize(String value, JsonGenerator gen, SerializerProvider provider)
      throws IOException {
    gen.writeString(convert(value));
  }


  @Override
  public boolean isEmpty(SerializerProvider prov, String value) {
    return !StringUtils.hasText(value);
  }


  @Override
  public final void serializeWithType(String value, JsonGenerator gen, SerializerProvider provider,
      TypeSerializer typeSer) throws IOException {
    gen.writeString(value);
  }

}
