package cn.bestwu.simpleframework.web.serializer;

import java.io.Serializable;

public interface ICodeNumberService extends ICodeService {

  default String getName(String codeType, Number code) {
    return String.valueOf(code);
  }

  @Override
  default String getName(String codeType, Serializable code) {
    return getName(codeType, (Number) code);
  }

  @Override
  default Number getCode(String codeType, String name) {
    try {
      return Integer.parseInt(name);
    } catch (NumberFormatException ignored) {
      return null;
    }
  }
}
