package cn.bestwu.simpleframework.web.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

/**
 * @author Peter Wu
 */
public class NullAsBlankSerializer extends StdSerializer<Object> {

  private static final long serialVersionUID = 1L;

  public NullAsBlankSerializer() {
    super(Object.class);
  }

  @Override
  public void serialize(Object value, JsonGenerator gen, SerializerProvider provider)
      throws IOException {
    gen.writeString("");
  }

  @Override
  public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider serializers,
      TypeSerializer typeSer)
      throws IOException {
    gen.writeString("");
  }

  @Override
  public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint)
      throws JsonMappingException {
    visitor.expectNullFormat(typeHint);
  }
}
