/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.config;

import cn.bestwu.simpleframework.web.serializer.CodeSerializer;
import cn.bestwu.simpleframework.web.serializer.ICodeService;
import cn.bestwu.simpleframework.web.serializer.UrlSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnWebApplication
public class SerializerConfiguration {
    public SerializerConfiguration(@Autowired(required=false) MappingJackson2XmlHttpMessageConverter xmlHttpMessageConverter, @Value(value="${spring.jackson.write-xml-declaration:false}") Boolean writeXmlDeclaration, @Value(value="${spring.jackson.xml-root-name:xml}") String xmlRootName) {
        if (xmlHttpMessageConverter != null && ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.xml.XmlMapper", (ClassLoader)SerializerConfiguration.class.getClassLoader())) {
            XmlMapper xmlMapper = (XmlMapper)xmlHttpMessageConverter.getObjectMapper();
            xmlMapper.setConfig((SerializationConfig)xmlMapper.getSerializationConfig().withRootName(xmlRootName));
            xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, writeXmlDeclaration.booleanValue());
        }
    }

    @Configuration
    @ConditionalOnBean(value={ICodeService.class})
    @ConditionalOnWebApplication
    protected static class CodeSerializerConfiguration {
        public CodeSerializerConfiguration(ICodeService codeService) {
            CodeSerializer.setCodeService(codeService);
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    protected static class UrlSerializerConfiguration {
        public UrlSerializerConfiguration(Environment environment) {
            UrlSerializer.setEnvironment(environment);
        }
    }
}

