/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.support.excel;

import cn.bestwu.simpleframework.support.excel.CellValueConverter;
import cn.bestwu.simpleframework.support.excel.ExcelField;
import cn.bestwu.simpleframework.support.excel.ExcelFieldDescription;
import cn.bestwu.simpleframework.support.excel.FieldType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExcelUtil {
    protected CellValueConverter getCellValueConverter(Class<? extends CellValueConverter> converter) throws InstantiationException, IllegalAccessException {
        CellValueConverter newInstance;
        try {
            newInstance = (CellValueConverter)converter.getMethod("newInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            newInstance = converter.newInstance();
        }
        return newInstance;
    }

    @NotNull
    public List<ExcelFieldDescription> getExcelFieldDescriptions(Class<?> cls, FieldType type, int ... groups) {
        Method[] methods;
        Field[] fields;
        ArrayList<ExcelFieldDescription> fieldDescriptions = new ArrayList<ExcelFieldDescription>();
        for (Field f : fields = cls.getDeclaredFields()) {
            this.readExcelField(fieldDescriptions, f, type, groups);
        }
        for (Method method : methods = cls.getMethods()) {
            this.readExcelField(fieldDescriptions, method, type, groups);
        }
        fieldDescriptions.sort(Comparator.comparingInt(o -> o.getExcelField().sort()));
        return fieldDescriptions;
    }

    private void readExcelField(List<ExcelFieldDescription> fieldDescriptions, AccessibleObject accessibleObject, FieldType type, int ... groups) {
        ExcelField excelField = accessibleObject.getAnnotation(ExcelField.class);
        if (excelField != null && (excelField.type().equals((Object)FieldType.ALL) || excelField.type().equals((Object)type))) {
            if (groups != null && groups.length > 0) {
                boolean inGroup = false;
                block0: for (int group : groups) {
                    if (!inGroup) {
                        for (int efg : excelField.groups()) {
                            if (group != efg) continue;
                            inGroup = true;
                            fieldDescriptions.add(new ExcelFieldDescription(excelField, accessibleObject));
                            continue block0;
                        }
                        continue;
                    }
                    break;
                }
            } else {
                fieldDescriptions.add(new ExcelFieldDescription(excelField, accessibleObject));
            }
        }
    }
}

