/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.support.excel;

import cn.bestwu.simpleframework.support.excel.AbstractExcelUtil;
import cn.bestwu.simpleframework.support.excel.CellValueConverter;
import cn.bestwu.simpleframework.support.excel.ExcelField;
import cn.bestwu.simpleframework.support.excel.ExcelFieldDescription;
import cn.bestwu.simpleframework.support.excel.ExcelImportException;
import cn.bestwu.simpleframework.support.excel.FieldType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class ExcelImport
extends AbstractExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelImport.class);
    private static final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    private Workbook workbook;
    private Class<?>[] validateGroups = new Class[]{Default.class};

    public ExcelImport(String fileName) throws IOException {
        this(new File(fileName));
    }

    public ExcelImport(File file) throws IOException {
        this(file.getName(), new FileInputStream(file));
    }

    public ExcelImport(MultipartFile multipartFile) throws IOException {
        this(multipartFile.getOriginalFilename(), multipartFile.getInputStream());
    }

    public ExcelImport(String fileName, InputStream is) throws IOException {
        if (!StringUtils.hasText((String)fileName)) {
            throw new RuntimeException("\u5bfc\u5165\u6587\u6863\u4e3a\u7a7a!");
        }
        if (fileName.toLowerCase().endsWith("xls")) {
            this.workbook = new HSSFWorkbook(is);
        } else if (fileName.toLowerCase().endsWith("xlsx")) {
            this.workbook = new XSSFWorkbook(is);
        } else {
            throw new RuntimeException("\u6587\u6863\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        log.debug("Initialize success.");
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public <E> List<E> getDataList(Class<? extends E> cls, int ... groups) throws InstantiationException, IllegalAccessException, NoSuchMethodException, ExcelImportException {
        return this.getDataList(0, 0, cls, groups);
    }

    public <E> List<E> getDataList(int sheetIndex, int headerNum, Class<? extends E> cls, int ... groups) throws InstantiationException, IllegalAccessException, NoSuchMethodException, ExcelImportException {
        if (this.workbook.getNumberOfSheets() < sheetIndex) {
            throw new RuntimeException("\u6587\u6863\u4e2d\u6ca1\u6709\u5de5\u4f5c\u8868!");
        }
        Sheet sheet = this.workbook.getSheetAt(sheetIndex);
        List<ExcelFieldDescription> fieldDescriptions = this.getExcelFieldDescriptions(cls, FieldType.IMPORT, groups);
        ArrayList<E> dataList = new ArrayList<E>();
        for (int i = headerNum + 1; i < sheet.getLastRowNum() + headerNum + 1; ++i) {
            E e;
            Row row = sheet.getRow(i);
            if (row == null || (e = this.readRow(fieldDescriptions, cls, row)) == null) continue;
            dataList.add(e);
        }
        return dataList;
    }

    public <E> E readRow(List<ExcelFieldDescription> fieldDescriptions, Class<E> cls, Row row) throws InstantiationException, IllegalAccessException, NoSuchMethodException, ExcelImportException {
        boolean notAllBlank = false;
        int column = 0;
        E e = cls.newInstance();
        StringBuilder sb = new StringBuilder();
        ArrayList<ExcelImportException.CellError> rowErrors = new ArrayList<ExcelImportException.CellError>();
        int rowNum = row.getRowNum() + 1;
        for (ExcelFieldDescription fieldDescription : fieldDescriptions) {
            Object val;
            if ((val = ExcelImport.getCellValue(row, column++)) != null) {
                notAllBlank = notAllBlank || StringUtils.hasText((String)val.toString());
                ExcelField ef = fieldDescription.getExcelField();
                Class valType = Class.class;
                AccessibleObject accessibleObject = fieldDescription.getAccessibleObject();
                if (accessibleObject instanceof Field) {
                    valType = ((Field)accessibleObject).getType();
                } else if (accessibleObject instanceof Method) {
                    Method method = (Method)accessibleObject;
                    if ("get".equals(method.getName().substring(0, 3))) {
                        valType = method.getReturnType();
                    } else if ("set".equals(method.getName().substring(0, 3))) {
                        valType = ((Method)accessibleObject).getParameterTypes()[0];
                    }
                }
                String valStr = String.valueOf(val).trim();
                try {
                    Class<? extends CellValueConverter> converter = ef.converter();
                    if (converter != CellValueConverter.class) {
                        CellValueConverter newInstance = this.getCellValueConverter(converter);
                        val = newInstance.fromCell(valStr, fieldDescription, e, row);
                    } else if (valType == String.class) {
                        if (val instanceof Number) {
                            String pattern = ef.pattern();
                            if (!StringUtils.hasText((String)pattern)) {
                                pattern = "0";
                            }
                            DecimalFormat df = new DecimalFormat(pattern);
                            val = df.format(new BigDecimal(valStr));
                        } else {
                            val = valStr;
                        }
                    } else if (StringUtils.hasText((String)valStr)) {
                        if (valType == Integer.class) {
                            val = Double.valueOf(valStr).intValue();
                        } else if (valType == Long.class) {
                            val = Double.valueOf(valStr).longValue();
                        } else if (valType == BigDecimal.class) {
                            val = new BigDecimal(valStr);
                        } else if (valType == Double.class) {
                            val = Double.valueOf(valStr);
                        } else if (valType == Float.class) {
                            val = Float.valueOf(valStr);
                        } else if (valType == Date.class) {
                            val = DateUtil.getJavaDate((double)Double.valueOf(valStr));
                        } else {
                            log.warn("Get cell value [" + rowNum + "," + column + "]");
                            val = null;
                        }
                    } else {
                        val = null;
                    }
                }
                catch (Exception ex) {
                    log.warn("Get cell value [" + rowNum + "," + column + "] error: " + ex.toString());
                    String message = ex.getMessage();
                    rowErrors.add(new ExcelImportException.CellError(rowNum, column - 1, ef.title(), valStr, new IllegalArgumentException(StringUtils.hasText((String)message) ? message : "typeMismatch", ex)));
                    val = null;
                }
                String propertyName = null;
                if (accessibleObject instanceof Field) {
                    propertyName = ((Field)accessibleObject).getName();
                    ReflectionUtils.invokeMethod((Method)BeanUtils.getPropertyDescriptor(e.getClass(), (String)propertyName).getWriteMethod(), e, (Object[])new Object[]{val});
                } else if (accessibleObject instanceof Method) {
                    String mthodName = ((Method)accessibleObject).getName();
                    if ("get".equals(mthodName.substring(0, 3))) {
                        propertyName = mthodName.substring(3);
                        mthodName = "set" + propertyName;
                        propertyName = StringUtils.uncapitalize((String)propertyName);
                    }
                    ReflectionUtils.invokeMethod((Method)cls.getMethod(mthodName, valType), e, (Object[])new Object[]{val});
                }
                ConstraintViolationException exception = this.validateProperty(e, propertyName, this.validateGroups);
                if (exception != null) {
                    rowErrors.add(new ExcelImportException.CellError(rowNum, column - 1, ef.title(), valStr, (Exception)exception));
                }
            }
            sb.append(val).append(", ");
        }
        if (!rowErrors.isEmpty()) {
            throw new ExcelImportException(((ExcelImportException.CellError)rowErrors.get(0)).getException().getMessage(), rowErrors);
        }
        log.debug("Read success: [" + rowNum + "] " + sb.toString());
        if (notAllBlank) {
            return e;
        }
        return null;
    }

    private ConstraintViolationException validateProperty(Object object, String propertyName, Class<?> ... groups) {
        Set constraintViolations = validator.validateProperty(object, propertyName, (Class[])groups);
        if (constraintViolations.isEmpty()) {
            return null;
        }
        return new ConstraintViolationException(constraintViolations);
    }

    public void validateGroups(Class<?> ... validateGroups) {
        this.validateGroups = validateGroups;
    }

    public static Object getCellValue(Row row, int column) {
        Object val = "";
        try {
            Cell cell = row.getCell(column);
            if (cell != null) {
                if (cell.getCellType() == CellType.NUMERIC) {
                    val = cell.getNumericCellValue();
                } else if (cell.getCellType() == CellType.STRING) {
                    val = cell.getStringCellValue();
                } else if (cell.getCellType() == CellType.FORMULA) {
                    val = cell.getCellFormula();
                } else if (cell.getCellType() == CellType.BOOLEAN) {
                    val = cell.getBooleanCellValue();
                } else if (cell.getCellType() == CellType.ERROR) {
                    val = cell.getErrorCellValue();
                }
            }
        }
        catch (Exception e) {
            log.warn(row + "\uff0c" + column + "\uff0c\u8bfb\u53d6\u6570\u636e\u9519\u8bef", (Throwable)e);
            return val;
        }
        return val;
    }
}

