/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.support.packagescan;

import cn.bestwu.simpleframework.support.packagescan.AssignableToPackageScanFilter;
import cn.bestwu.simpleframework.support.packagescan.CompositePackageScanFilter;
import cn.bestwu.simpleframework.support.packagescan.PackageScanFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tomcat.util.buf.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public class PackageScanClassResolver {
    private final Logger log = LoggerFactory.getLogger(PackageScanClassResolver.class);
    private Set<PackageScanFilter> scanFilters;
    private final Map<String, Set<Class>> allClassesByPackage = new HashMap<String, Set<Class>>();
    private final Set<String> loadedPackages = new HashSet<String>();
    private ResourcePatternResolver resourcePatternResolver;
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);

    public PackageScanClassResolver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public PackageScanClassResolver(ClassLoader classLoader) {
        this.resourcePatternResolver = new PathMatchingResourcePatternResolver(classLoader);
    }

    @NotNull
    public static Set<String> detectPackagesToScan(ApplicationContext applicationContext, String[] basePackages) {
        Assert.notNull((Object)applicationContext, (String)"applicationContext \u4e0d\u80fd\u4e3anull");
        HashSet<String> packages = new HashSet<String>();
        if (basePackages.length == 0) {
            for (Object o : applicationContext.getBeansWithAnnotation(ComponentScan.class).values()) {
                ComponentScan annotation = (ComponentScan)AnnotatedElementUtils.findMergedAnnotation(o.getClass(), ComponentScan.class);
                for (Class aClass : annotation.basePackageClasses()) {
                    packages.add(aClass.getPackage().getName());
                }
                packages.addAll(Arrays.asList(annotation.basePackages()));
                if (!packages.isEmpty()) continue;
                packages.add(o.getClass().getPackage().getName());
            }
        } else {
            packages.addAll(Arrays.asList(basePackages));
        }
        return packages;
    }

    public void addFilter(PackageScanFilter filter) {
        if (this.scanFilters == null) {
            this.scanFilters = new LinkedHashSet<PackageScanFilter>();
        }
        this.scanFilters.add(filter);
    }

    public void removeFilter(PackageScanFilter filter) {
        if (this.scanFilters != null) {
            this.scanFilters.remove(filter);
        }
    }

    public Set<Class<?>> findImplementations(Class parent, String ... packageNames) {
        if (packageNames == null) {
            return Collections.emptySet();
        }
        this.log.debug("Searching for implementations of " + parent.getName() + " in packages: " + Arrays.asList(packageNames));
        PackageScanFilter test = this.getCompositeFilter(new AssignableToPackageScanFilter(parent));
        return this.findByFilter(test, packageNames);
    }

    public Set<Class<?>> findByFilter(PackageScanFilter filter, String ... packageNames) {
        if (packageNames == null) {
            return Collections.emptySet();
        }
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(filter, pkg, classes);
        }
        this.log.debug("Found: " + classes);
        return classes;
    }

    protected void find(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        if (!this.loadedPackages.contains(packageName = packageName.replace('.', '/'))) {
            this.findAllClasses(packageName);
            this.loadedPackages.add(packageName);
        }
        this.findInAllClasses(test, packageName, classes);
    }

    protected void findAllClasses(String packageName) {
        try {
            Resource[] resources;
            String packageSearchPath = "classpath*:" + this.resolveBasePackage(packageName) + "/**/*.class";
            for (Resource resource : resources = this.resourcePatternResolver.getResources(packageSearchPath)) {
                if (!resource.isReadable()) continue;
                MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(resource);
                String className = metadataReader.getClassMetadata().getClassName();
                try {
                    Class<?> type = Class.forName(className);
                    this.addFoundClass(type);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    this.log.info("\u52a0\u8f7d" + className + "\u5931\u8d25\uff0c" + e.getMessage());
                }
            }
        }
        catch (IOException e) {
            this.log.warn("Cannot read package: " + packageName, (Throwable)e);
        }
    }

    private String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }

    protected void findInAllClasses(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        this.log.debug("Searching for: " + test + " in package: " + packageName);
        Set<Class> packageClasses = this.getFoundClasses(packageName);
        if (packageClasses == null) {
            this.log.debug("No classes found in package: " + packageName);
            return;
        }
        for (Class type : packageClasses) {
            if (!test.matches(type)) continue;
            classes.add(type);
        }
    }

    protected void addFoundClass(Class<?> type) {
        if (type.getPackage() != null) {
            String packageName = type.getPackage().getName();
            List<String> packageNameParts = Arrays.asList(packageName.split("\\."));
            for (int i = 0; i < packageNameParts.size(); ++i) {
                String thisPackage = StringUtils.join(packageNameParts.subList(0, i + 1), (char)'/');
                this.addFoundClass(thisPackage, type);
            }
        }
    }

    protected void addFoundClass(String packageName, Class<?> type) {
        if (!this.allClassesByPackage.containsKey(packageName = packageName.replace("/", "."))) {
            this.allClassesByPackage.put(packageName, new HashSet());
        }
        this.allClassesByPackage.get(packageName).add(type);
    }

    protected Set<Class> getFoundClasses(String packageName) {
        packageName = packageName.replace("/", ".");
        return this.allClassesByPackage.get(packageName);
    }

    private PackageScanFilter getCompositeFilter(PackageScanFilter filter) {
        if (this.scanFilters != null) {
            CompositePackageScanFilter composite = new CompositePackageScanFilter(this.scanFilters);
            composite.addFilter(filter);
            return composite;
        }
        return filter;
    }
}

