/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.CorsProcessor;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.cors.DefaultCorsProcessor;
import org.springframework.web.servlet.ModelAndView;

@Controller
@ConditionalOnWebApplication
@ConditionalOnMissingBean(value={ErrorController.class})
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
public class CustomErrorController
extends BasicErrorController {
    private Logger log = LoggerFactory.getLogger(CustomErrorController.class);
    private CorsProcessor processor = new DefaultCorsProcessor();
    private final CorsConfigurationSource configSource;
    private final Boolean okEnable;

    public CustomErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties, @Autowired(required=false) @Qualifier(value="corsConfigurationSource") CorsConfigurationSource configSource, Boolean okEnable) {
        super(errorAttributes, errorProperties);
        this.configSource = configSource;
        this.okEnable = okEnable;
    }

    @RequestMapping(produces={"text/html"})
    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
        Map model = Collections.unmodifiableMap(this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.TEXT_HTML)));
        HttpStatus status = this.getStatus(request);
        response.setStatus(status.value());
        ModelAndView modelAndView = this.resolveErrorView(request, response, status, model);
        this.setCors(request, response);
        return modelAndView == null ? new ModelAndView("error", model) : modelAndView;
    }

    private void setCors(HttpServletRequest request, HttpServletResponse response) {
        CorsConfiguration corsConfiguration;
        if (this.configSource != null && CorsUtils.isCorsRequest((HttpServletRequest)request) && (corsConfiguration = this.configSource.getCorsConfiguration(request)) != null) {
            try {
                this.processor.processRequest(corsConfiguration, request, response);
            }
            catch (IOException e) {
                this.log.error("\u8de8\u57df\u8bbe\u7f6e\u51fa\u9519", (Throwable)e);
            }
        }
    }

    @RequestMapping
    @ResponseBody
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        Map body = this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.ALL));
        HttpStatus status = this.getStatus(request);
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            this.setCors(request, requestAttributes.getResponse());
        }
        if (this.okEnable.booleanValue()) {
            status = HttpStatus.OK;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).headers(this.noCache())).body((Object)body);
    }

    protected HttpHeaders noCache() {
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl("no-cache, no-store, max-age=0, must-revalidate");
        headers.setPragma("no-cache");
        headers.setExpires(-1L);
        return headers;
    }
}

