/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web.resolver;

import cn.bestwu.simpleframework.web.RespEntity;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.HttpEntityMethodProcessor;

public class WrapperHttpEntityMethodProcessor
extends HttpEntityMethodProcessor {
    private final Boolean okEnable;

    public WrapperHttpEntityMethodProcessor(List<HttpMessageConverter<?>> converters, ContentNegotiationManager manager, List<Object> requestResponseBodyAdvice, Boolean okEnable) {
        super(converters, manager, requestResponseBodyAdvice);
        this.okEnable = okEnable;
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        HttpEntity responseEntity = (HttpEntity)returnValue;
        if (responseEntity instanceof ResponseEntity) {
            int statusCode = ((ResponseEntity)responseEntity).getStatusCode().value();
            if (this.okEnable.booleanValue() && statusCode != 404 && statusCode != 405) {
                returnValue = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseEntity.getHeaders())).body(responseEntity.getBody());
            }
        }
        super.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
    }

    protected <T> void writeWithMessageConverters(T value, MethodParameter returnType, ServletServerHttpRequest inputMessage, ServletServerHttpResponse outputMessage) throws IOException, HttpMediaTypeNotAcceptableException, HttpMessageNotWritableException {
        Object val = value;
        if (value != null && !value.getClass().equals(RespEntity.class)) {
            val = value instanceof Exception ? new RespEntity(String.valueOf(HttpStatus.BAD_REQUEST.value()), ((Exception)value).getMessage()) : new RespEntity(value);
        } else if (val == null) {
            val = new RespEntity((Object)Collections.emptyMap());
        }
        super.writeWithMessageConverters(val, returnType, inputMessage, outputMessage);
    }
}

