/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web.serializer;

import cn.bestwu.simpleframework.web.serializer.annotation.JsonStringReplace;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import org.springframework.util.StringUtils;

@JacksonStdImpl
public class StringReplaceSerializer
extends StdScalarSerializer<String>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    private final String target;
    private final String replacement;

    public StringReplaceSerializer() {
        super(String.class, false);
        this.target = "";
        this.replacement = "";
    }

    public StringReplaceSerializer(String target, String replacement) {
        super(String.class, false);
        this.target = target;
        this.replacement = replacement;
    }

    public void serialize(String value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(StringUtils.hasText((String)value) && StringUtils.hasText((String)this.target) ? value.replace(this.target, this.replacement) : value);
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        if (property != null) {
            JsonStringReplace stringReplace = (JsonStringReplace)property.getAnnotation(JsonStringReplace.class);
            if (stringReplace == null) {
                throw new RuntimeException("\u672a\u6ce8\u89e3@" + JsonStringReplace.class.getName());
            }
            return new StringReplaceSerializer(stringReplace.value(), stringReplace.replacement());
        }
        return this;
    }

    public boolean isEmpty(SerializerProvider prov, String value) {
        return !StringUtils.hasText((String)value);
    }

    public final void serializeWithType(String value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, provider);
    }
}

