/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web.validator;

import cn.bestwu.simpleframework.web.validator.IDCardUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDCardInfo {
    private static final Logger logger = LoggerFactory.getLogger(IDCardInfo.class);
    private static ResourceBundle areaNumberBundle;
    private String idcard;
    private String province;
    private String city;
    private String region;
    private int year;
    private int month;
    private int day;
    private String gender;
    private long birthday;
    private boolean legal;

    private String getString(String key, String defaultVal) {
        return areaNumberBundle.containsKey(key) ? areaNumberBundle.getString(key) : defaultVal;
    }

    public IDCardInfo(String idcard) {
        this.idcard = idcard;
        if (IDCardUtil.validate(idcard)) {
            this.legal = true;
            if (idcard.length() == 15) {
                idcard = IDCardUtil.convertFrom15bit(idcard);
            }
            String provinceId = idcard.substring(0, 2);
            String cityId = idcard.substring(2, 4);
            String regionId = idcard.substring(4, 6);
            this.province = this.getString(provinceId + "0000", null);
            this.city = this.getString(provinceId + cityId + "00", null);
            this.region = this.getString(provinceId + cityId + regionId, null);
            String id17 = idcard.substring(16, 17);
            this.gender = Integer.parseInt(id17) % 2 != 0 ? "\u7537" : "\u5973";
            String birthday = idcard.substring(6, 14);
            try {
                Date birthdate = new SimpleDateFormat("yyyyMMdd").parse(birthday);
                this.birthday = birthdate.getTime();
                GregorianCalendar currentDay = new GregorianCalendar();
                currentDay.setTime(birthdate);
                this.year = currentDay.get(1);
                this.month = currentDay.get(2) + 1;
                this.day = currentDay.get(5);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public long getBirthday() {
        return this.birthday;
    }

    public void setBirthday(long birthday) {
        this.birthday = birthday;
    }

    public boolean isLegal() {
        return this.legal;
    }

    public void setLegal(boolean legal) {
        this.legal = legal;
    }

    public String getIdcard() {
        return this.idcard;
    }

    public void setIdcard(String idcard) {
        this.idcard = idcard;
    }

    public String toString() {
        if (this.legal) {
            return "\u51fa\u751f\u5730\uff1a" + this.province + this.city + this.region + ",\u751f\u65e5\uff1a" + this.year + "\u5e74" + this.month + "\u6708" + this.day + "\u65e5,\u6027\u522b\uff1a" + this.gender;
        }
        return "\u975e\u6cd5\u8eab\u4efd\u8bc1\u53f7\u7801";
    }

    static {
        try {
            areaNumberBundle = ResourceBundle.getBundle("areaNumber");
        }
        catch (MissingResourceException e) {
            logger.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
    }
}

