package cn.boboweike.carrot;

import cn.boboweike.carrot.configuration.Carrot;
import cn.boboweike.carrot.scheduling.BackgroundTask;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.nosql.mongo.MongoDBPartitionedStorageProvider;

import java.util.concurrent.TimeUnit;

public class Main {
    public static void main(String[] args) throws InterruptedException {

        String connectionString = "mongodb://root:rootpassword@localhost:27017";
        PartitionedStorageProvider storageProvider = new MongoDBPartitionedStorageProvider(
                connectionString,
                9
        );

        Carrot.configure()
                .useStorageProvider(storageProvider)
                .useBackgroundTaskServer()
                .useDashboard()
                .initialize();

        while (true) {
            BackgroundTask.enqueue(() -> System.out.println("Simple!"));
            TimeUnit.MILLISECONDS.sleep(2000);
        }
    }
}
